<?php

/**
 * Create settings & controls for the main navigation
 *
 * @since 0.0.07
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_main_navigation_settings_controls( $wp_customize ) {
	// Seperator
	$wp_customize->add_setting(
		'main_general_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'main_general_title',
			array(
				'priority' => 0,
				'section'  => 'main_navigation_options',
				'label'    => __( 'General settings', 'klasse-theme' ),
			)
		)
	);
	// Toggle main navigation
	$wp_customize->add_setting(
		'main_navigation_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'main_navigation_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'main_navigation_options',
			'label'    => __( 'Main navigation toggle', 'klasse-theme' ),
		)
	);
	// Select navigation type
	$wp_customize->add_setting(
		'main_navigation_version',
		array(
			'default'   => '',
			// 'sanitize_callback' => 'sanitize_select_field',
			'transport' => 'refresh',
			'type'      => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		'main_navigation_version',
		array(
			'priority' => 0,
			'type'     => 'select',
			'section'  => 'main_navigation_options',
			'label'    => __( 'Main navigation theme selection', 'klasse-theme' ),
			'choices'  => $GLOBALS['kls_main_navigation'],
		)
	);
	// Fixed navigation padding
	$wp_customize->add_setting(
		'main_navigation_padding_size',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'main_navigation_padding_size',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'main_navigation_options',
			'label'    => __( 'Main navigation padding size', 'klasse-theme' ),
		)
	);

	// Logo max height
	$wp_customize->add_setting(
		'kls_logo_height',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'kls_logo_height',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'main_navigation_options',
			'label'    => __( 'Logo height in pixels', 'klasse-theme' ),
		)
	);
	// Seperator
	$wp_customize->add_setting(
		'main_toggles_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'main_toggles_title',
			array(
				'priority' => 0,
				'section'  => 'main_navigation_options',
				'label'    => __( 'Toggleable items', 'klasse-theme' ),
			)
		)
	);
	// Toggle search icon
	$wp_customize->add_setting(
		'search_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'search_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'main_navigation_options',
			'label'    => __( 'Search function toggle', 'klasse-theme' ),
		)
	);

	// Toggle secundary menu
	$wp_customize->add_setting(
		'kls_center_menu_toggle_secundary_menu',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'kls_center_menu_toggle_secundary_menu',
		array(
			'type'            => 'checkbox',
			'priority'        => 0,
			'section'         => 'main_navigation_options',
			'label'           => __( 'Toggle the secundary menu on the right of the center menu', 'klasse-theme' ),
			'active_callback' => function () use ( $wp_customize ) {
				return 'center-v1' == $wp_customize->get_setting( 'main_navigation_version' )->value();
			},
		)
	);

	// Toggle sidemenu
	$wp_customize->add_setting(
		'kls_sidemenu_navigation_toggle',
		array(
			'default' => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport' => 'refresh',
		)
	);
	$wp_customize->add_control(
		'kls_sidemenu_navigation_toggle',
		array(
			'type' => 'checkbox',
			'priority' => 0,
			'section' => 'main_navigation_options',
			'label' => __('Change the menu from visible to a sidemenu toggle', 'klasse-theme'),
			'active_callback' => function () use ($wp_customize) {
				return 'center-v1' == $wp_customize->get_setting('main_navigation_version')->value();
			},
		)
	);

	// Toggle rating stars
	$wp_customize->add_setting(
		'navigation_rating_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'navigation_rating_toggle',
		array(
			'type'        => 'checkbox',
			'priority'    => 0,
			'section'     => 'main_navigation_options',
			'description' => __( 'The settings can be found in the theme settings.', 'klasse-theme' ),
			'label'       => __( 'Toggle rating in the main navigation', 'klasse-theme' ),
		)
	);
	// Seperator
	$wp_customize->add_setting(
		'main_fonts_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'main_fonts_title',
			array(
				'priority' => 0,
				'section'  => 'main_navigation_options',
				'label'    => __( 'Font settings', 'klasse-theme' ),
			)
		)
	);
	// Menu background color
	$wp_customize->add_setting(
		'main_navigation_background_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'main_navigation_background_color',
			array(
				'label'        => __( 'Navigation background color', 'klasse-theme' ),
				'section'      => 'main_navigation_options',
				'priority'     => 0,
				'show_opacity' => true,
			)
		)
	);
	// Main nav on scroll background color
	$wp_customize->add_setting(
		'main_navigation_scroll_background_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);

	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'main_navigation_scroll_background_color',
			array(
				'label'        => __( 'Fixed navigation background color', 'klasse-theme' ),
				'section'      => 'main_navigation_options',
				'priority'     => 0,
				'show_opacity' => true,
			)
		)
	);

	// Main navigation font size
	$wp_customize->add_setting(
		'main_navigation_font_size',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'main_navigation_font_size',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'main_navigation_options',
			'label'    => __( 'Main navigation font size', 'klasse-theme' ),
		)
	);

	// Main navigation font size
	$wp_customize->add_setting(
		'main_navigation_icon_font_size',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'main_navigation_icon_font_size',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'main_navigation_options',
			'label'    => __( 'Main navigation icon font size', 'klasse-theme' ),
		)
	);

	// Main navigation font weight
	$wp_customize->add_setting(
		'main_navigation_font_weight',
		array(
			'default'   => '',
			// 'sanitize_callback' => 'sanitize_select_field',
			'transport' => 'refresh',
			'type'      => 'theme_mod',
		)
	);

	$wp_customize->add_control(
		'main_navigation_font_weight',
		array(
			'priority' => 0,
			'type'     => 'select',
			'section'  => 'main_navigation_options',
			'label'    => __( 'Main navigation font weight', 'klasse-theme' ),
			'choices'  => array(
				'normal'  => __( 'Normal', 'klasse-theme' ),
				'bold'    => __( 'Bold', 'klasse-theme' ),
				'bolder'  => __( 'Bolder', 'klasse-theme' ),
				'lighter' => __( 'Light', 'klasse-theme' ),
			),
		)
	);

	// Main navigation line height
	$wp_customize->add_setting(
		'kls_main_navigation_line_height',
		array(
			'default' => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport' => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_main_navigation_line_height',
		array(
			'type' => 'text',
			'priority' => 0,
			'section' => 'main_navigation_options',
			'label' => __('Sidemenu text line height', 'klasse-theme'),
		)
	);

	// Main navigation text transform
	$wp_customize->add_setting(
		'kls_main_navigation_text_transform',
		array(
			'default' => '',
			// 'sanitize_callback' => 'sanitize_select_field',
			'transport' => 'refresh',
			'type' => 'theme_mod',
		)
	);

	$wp_customize->add_control(
		'kls_main_navigation_text_transform',
		array(
			'priority' => 0,
			'type' => 'select',
			'section' => 'main_navigation_options',
			'label' => __('Text transform', 'klasse-theme'),
			'choices' => array(
				'none' => __('None', 'klasse-theme'),
				'capitalize' => __('Capitalize', 'klasse-theme'),
				'uppercase' => __('Uppercase', 'klasse-theme'),
				'lowercase' => __('Lowercase', 'klasse-theme'),
				'initial' => __('Initial', 'klasse-theme'),
			),
		)
	);

	// Seperator
	$wp_customize->add_setting(
		'main_colors_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);

	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'main_colors_title',
			array(
				'priority' => 0,
				'section'  => 'main_navigation_options',
				'label'    => __( 'Colors', 'klasse-theme' ),
			)
		)
	);

	// Menu background color
	$wp_customize->add_setting(
		'main_navigation_background_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);

	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'main_navigation_background_color',
			array(
				'label'        => __( 'Navigation background color', 'klasse-theme' ),
				'section'      => 'main_navigation_options',
				'priority'     => 0,
				'show_opacity' => true,
			)
		)
	);

	// Main nav on scroll background color
	$wp_customize->add_setting(
		'main_navigation_scroll_background_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);

	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'main_navigation_scroll_background_color',
			array(
				'label'        => __( 'Fixed navigation background color', 'klasse-theme' ),
				'section'      => 'main_navigation_options',
				'priority'     => 0,
				'show_opacity' => true,
			)
		)
	);

	// Seperator
	$wp_customize->add_setting(
		'main_navigation_fixed_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);

	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'main_navigation_fixed_title',
			array(
				'priority' => 0,
				'section'  => 'main_navigation_options',
				'label'    => __( 'Fixed navigation settings', 'klasse-theme' ),
			)
		)
	);

	// Fixed navigation padding
	$wp_customize->add_setting(
		'main_navigation_fixed_padding_size',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'main_navigation_fixed_padding_size',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'main_navigation_options',
			'label'    => __( 'Main navigation fixed padding size', 'klasse-theme' ),
		)
	);

	// Seperator
	$wp_customize->add_setting(
		'main_navigation_buttons_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);

	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'main_navigation_buttons_title',
			array(
				'priority' => 0,
				'section'  => 'main_navigation_options',
				'label'    => __( 'Navigation default v2 button settings', 'klasse-theme' ),
			)
		)
	);

	// Toggle navigation primary button
	$wp_customize->add_setting(
		'main_navigation_button_primary_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'main_navigation_button_primary_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'main_navigation_options',
			'label'    => __( 'Primary button toggle', 'klasse-theme' ),
		)
	);

	// Navigation primary button text
	$wp_customize->add_setting(
		'main_navigation_button_primary_text',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'main_navigation_button_primary_text',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'main_navigation_options',
			'label'    => __( 'Main navigation primary button text', 'klasse-theme' ),
		)
	);

	// Navigation primary button page
	$wp_customize->add_setting(
		'main_navigation_button_primary_link',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'main_navigation_button_primary_link',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'main_navigation_options',
			'label'    => __( 'Main navigation primary button link', 'klasse-theme' ),
		)
	);

	// Open secundary link in new tab
	$wp_customize->add_setting(
		'main_navigation_button_primary_link_blank',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'main_navigation_button_primary_link_blank',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'main_navigation_options',
			'label'    => __( 'Open primary link in new tab?', 'klasse-theme' ),
		)
	);

	// Toggle navigation secundary button
	$wp_customize->add_setting(
		'main_navigation_button_secundary_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'main_navigation_button_secundary_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'main_navigation_options',
			'label'    => __( 'Secundary button toggle', 'klasse-theme' ),
		)
	);

	// Navigation secundary button text
	$wp_customize->add_setting(
		'main_navigation_button_secundary_text',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'main_navigation_button_secundary_text',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'main_navigation_options',
			'label'    => __( 'Main navigation secundary button text', 'klasse-theme' ),
		)
	);

	// Navigation secundary button page
	$wp_customize->add_setting(
		'main_navigation_button_secundary_link',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'main_navigation_button_secundary_link',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'main_navigation_options',
			'label'    => __( 'Main navigation secundary button link', 'klasse-theme' ),
		)
	);

	// Navigation secundary button AF link
	$wp_customize->add_setting(
		'main_navigation_button_secundary_link_af',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'main_navigation_button_secundary_link_af',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'main_navigation_options',
			'label'    => __( 'Set secundary link to the Anytime Fitness registration link?', 'klasse-theme' ),
		)
	);

	// Open primary link in new tab
	$wp_customize->add_setting(
		'main_navigation_button_secundary_link_blank',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'main_navigation_button_secundary_link_blank',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'main_navigation_options',
			'label'    => __( 'Open secundary link in new tab?', 'klasse-theme' ),
		)
	);

	// Navigation shop v5.
	$wp_customize->add_setting(
		'kls_main_navigation_v5_button_link',
		array(
			'default'           => '',
			'sanitize_callback' => 'themeslug_sanitize_dropdown_pages',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_main_navigation_v5_button_link',
		array(
			'type'            => 'dropdown-pages',
			'priority'        => 0,
			'section'         => 'main_navigation_options',
			'label'           => __( 'Shop v5 frontend button link', 'klasse-theme' ),
			'active_callback' => function() use ( $wp_customize ) {
				return 'shop-v5' == $wp_customize->get_setting( 'main_navigation_version' )->value();
			},
		)
	);
}
add_action( 'customize_register', 'kls_create_main_navigation_settings_controls' );
