<?php

/**
 * Create settings & controls for the main navigation
 *
 * @since 0.1.79
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_sidemenu_settings_controls( $wp_customize ) {
	// Seperator
	$wp_customize->add_setting(
		'sidemenu_general_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'sidemenu_general_title',
			array(
				'priority' => 0,
				'section'  => 'sidemenu_navigation_options',
				'label'    => __( 'General settings', 'klasse-theme' ),
			)
		)
	);
	// Select navigation type
	$wp_customize->add_setting(
		'kls_sidemenu_version',
		array(
			'default'   => '',
			// 'sanitize_callback' => 'sanitize_select_field',
			'transport' => 'refresh',
			'type'      => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		'kls_sidemenu_version',
		array(
			'priority' => 0,
			'type'     => 'select',
			'section'  => 'sidemenu_navigation_options',
			'label'    => __( 'Main navigation theme selection', 'klasse-theme' ),
			'choices'  => array(
				'v1' => __('Version 1', 'klasse-theme'),
			),
		)
	);
	
	// Seperator
	$wp_customize->add_setting(
		'sidemenu_toggles_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'sidemenu_toggles_title',
			array(
				'priority' => 0,
				'section'  => 'sidemenu_navigation_options',
				'label'    => __( 'Toggleable items', 'klasse-theme' ),
			)
		)
	);

	// Show hamburger as button
	$wp_customize->add_setting(
		'kls_sidemenu_hamburger_button',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'kls_sidemenu_hamburger_button',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'sidemenu_navigation_options',
			'label'    => __( 'Show hamburger as button toggle', 'klasse-theme' ),
		)
	);

	// Main navigation font size
	$wp_customize->add_setting(
		'kls_sidemenu_width',
		array(
			'default' => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport' => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_sidemenu_width',
		array(
			'type' => 'text',
			'priority' => 0,
			'section' => 'sidemenu_navigation_options',
			'label' => __('Sidemenu maximum width', 'klasse-theme'),
		)
	);

	
	// Seperator
	$wp_customize->add_setting(
		'sidemenu_fonts_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'sidemenu_fonts_title',
			array(
				'priority' => 0,
				'section'  => 'sidemenu_navigation_options',
				'label'    => __( 'Font settings', 'klasse-theme' ),
			)
		)
	);

	// Main navigation font size
	$wp_customize->add_setting(
		'kls_sidemenu_font_size',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_sidemenu_font_size',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'sidemenu_navigation_options',
			'label'    => __( 'Sidemenu font size', 'klasse-theme' ),
		)
	);

	// Main navigation font size
	$wp_customize->add_setting(
		'kls_sidemenu_submenu_font_size',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_sidemenu_submenu_font_size',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'sidemenu_navigation_options',
			'label'    => __( 'Sidemenu sub menu font size', 'klasse-theme' ),
		)
	);

	// Main navigation font size
	$wp_customize->add_setting(
		'kls_sidemenu_line_height',
		array(
			'default' => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport' => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_sidemenu_line_height',
		array(
			'type' => 'text',
			'priority' => 0,
			'section' => 'sidemenu_navigation_options',
			'label' => __('Sidemenu text line height', 'klasse-theme'),
		)
	);

	// Main navigation font weight
	$wp_customize->add_setting(
		'kls_sidemenu_font_weight',
		array(
			'default'   => '',
			'transport' => 'refresh',
			'type'      => 'theme_mod',
		)
	);

	$wp_customize->add_control(
		'kls_sidemenu_font_weight',
		array(
			'priority' => 0,
			'type'     => 'select',
			'section'  => 'sidemenu_navigation_options',
			'label'    => __( 'Sidemenu font weight', 'klasse-theme' ),
			'choices'  => array(
				'normal'  => __( 'Normal', 'klasse-theme' ),
				'bold'    => __( 'Bold', 'klasse-theme' ),
				'bolder'  => __( 'Bolder', 'klasse-theme' ),
				'lighter' => __( 'Light', 'klasse-theme' ),
			),
		)
	);

	// Main navigation font weight
	$wp_customize->add_setting(
		'kls_sidemenu_submenu_font_weight',
		array(
			'default' => '',
			'transport' => 'refresh',
			'type' => 'theme_mod',
		)
	);

	$wp_customize->add_control(
		'kls_sidemenu_submenu_font_weight',
		array(
			'priority' => 0,
			'type' => 'select',
			'section' => 'sidemenu_navigation_options',
			'label' => __('Sidemenu submenu font weight', 'klasse-theme'),
			'choices' => array(
				'normal' => __('Normal', 'klasse-theme'),
				'bold' => __('Bold', 'klasse-theme'),
				'bolder' => __('Bolder', 'klasse-theme'),
				'lighter' => __('Light', 'klasse-theme'),
			),
		)
	);

	// Button text transform
	$wp_customize->add_setting(
		'kls_sidemenu_text_transform',
		array(
			'default' => '',
			// 'sanitize_callback' => 'sanitize_select_field',
			'transport' => 'refresh',
			'type' => 'theme_mod',
		)
	);

	$wp_customize->add_control(
		'kls_sidemenu_text_transform',
		array(
			'priority' => 0,
			'type' => 'select',
			'section' => 'sidemenu_navigation_options',
			'label' => __('Text transform', 'klasse-theme'),
			'choices' => array(
				'none' => __('None', 'klasse-theme'),
				'capitalize' => __('Capitalize', 'klasse-theme'),
				'uppercase' => __('Uppercase', 'klasse-theme'),
				'lowercase' => __('Lowercase', 'klasse-theme'),
				'initial' => __('Initial', 'klasse-theme'),
			),
		)
	);

	// Seperator
	$wp_customize->add_setting(
		'sidemenu_colors_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);

	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'sidemenu_colors_title',
			array(
				'priority' => 0,
				'section'  => 'sidemenu_navigation_options',
				'label'    => __( 'Colors', 'klasse-theme' ),
			)
		)
	);

	// Menu background color
	$wp_customize->add_setting(
		'kls_sidemenu_background_color',
		array(
			'default' => '',
			'transport' => 'refresh',
			'capability' => 'edit_theme_options',
			'type' => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'kls_sidemenu_background_color',
			array(
				'label' => __('Navigation background color', 'klasse-theme'),
				'section' => 'sidemenu_navigation_options',
				'priority' => 0,
				'show_opacity' => true,
			)
		)
	);

	// Menu text color
	$wp_customize->add_setting(
		'kls_sidemenu_text_color',
		array(
			'default' => '',
			'transport' => 'refresh',
			'capability' => 'edit_theme_options',
			'type' => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'kls_sidemenu_text_color',
			array(
				'label' => __('Navigation text color', 'klasse-theme'),
				'section' => 'sidemenu_navigation_options',
				'priority' => 0,
				'show_opacity' => true,
			)
		)
	);

	// Menu text color
	$wp_customize->add_setting(
		'kls_sidemenu_text_hover_color',
		array(
			'default' => '',
			'transport' => 'refresh',
			'capability' => 'edit_theme_options',
			'type' => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'kls_sidemenu_text_hover_color',
			array(
				'label' => __('Sidemenu text hover color', 'klasse-theme'),
				'section' => 'sidemenu_navigation_options',
				'priority' => 0,
				'show_opacity' => true,
			)
		)
	);

	// Menu text color
	$wp_customize->add_setting(
		'kls_sidemenu_hamburger_color',
		array(
			'default' => '',
			'transport' => 'refresh',
			'capability' => 'edit_theme_options',
			'type' => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'kls_sidemenu_hamburger_color',
			array(
				'label' => __('Hamburger color', 'klasse-theme'),
				'section' => 'sidemenu_navigation_options',
				'priority' => 0,
				'show_opacity' => true,
			)
		)
	);
}
add_action( 'customize_register', 'kls_create_sidemenu_settings_controls' );
