<?php

/**
 * Create settings & controls for the top navigation
 *
 * @since 0.0.07
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * [Dev] Todo, create an option to choose your own top nav positions.
 */
function kls_create_top_navigation_settings_controls( $wp_customize ) {
	// Seperator.
	$wp_customize->add_setting(
		'top_general_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'top_general_title',
			array(
				'priority' => 0,
				'section'  => 'top_navigation_options',
				'label'    => __( 'General settings', 'klasse-theme' ),
			)
		)
	);
	// Toggle top navigation.
	$wp_customize->add_setting(
		'top_navigation_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'top_navigation_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'top_navigation_options',
			'label'    => __( 'Top navigation toggle', 'klasse-theme' ),
		)
	);
	// Select navigation type.
	$wp_customize->add_setting(
		'top_navigation_version',
		array(
			'default'   => '',
			// 'sanitize_callback' => 'sanitize_select_field',
			'transport' => 'refresh',
			'type'      => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		'top_navigation_version',
		array(
			'priority' => 0,
			'type'     => 'select',
			'section'  => 'top_navigation_options',
			'label'    => __( 'Top navigation theme selection', 'klasse-theme' ),
			'choices'  => array(
				'default-v1' => __( 'Default v1', 'klasse-theme' ),
				'shop-v1'    => __( 'Shop v1', 'klasse-theme' ),
			),
		)
	);
	// Seperator.
	$wp_customize->add_setting(
		'top_toggles_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'top_toggles_title',
			array(
				'priority' => 0,
				'section'  => 'top_navigation_options',
				'label'    => __( 'Toggleable items', 'klasse-theme' ),
			)
		)
	);
	// Toggle top navigation contact info.
	$wp_customize->add_setting(
		'top_navigation_toggle_contact_info',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'top_navigation_toggle_contact_info',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'top_navigation_options',
			'label'    => __( 'Top navigation contact info toggle', 'klasse-theme' ),
		)
	);
	// Toggle top navigation toggle contact info text.
	$wp_customize->add_setting(
		'top_navigation_toggle_contact_info_text',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'top_navigation_toggle_contact_info_text',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'top_navigation_options',
			'label'    => __( 'Top navigation contact info text toggle', 'klasse-theme' ),
		)
	);
	// Toggle menu.
	$wp_customize->add_setting(
		'top_navigation_toggle_menu',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'top_navigation_toggle_menu',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'top_navigation_options',
			'label'    => __( 'Top navigation toggle menu', 'klasse-theme' ),
		)
	);
	// Toggle socials.
	$wp_customize->add_setting(
		'top_navigation_toggle_socials',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'top_navigation_toggle_socials',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'top_navigation_options',
			'label'    => __( 'Top navigation toggle socials', 'klasse-theme' ),
		)
	);
	// Toggle socials text.
	$wp_customize->add_setting(
		'top_navigation_toggle_socials_text',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'top_navigation_toggle_socials_text',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'top_navigation_options',
			'label'    => __( 'Top navigation toggle socials text', 'klasse-theme' ),
		)
	);
	// Toggle rating.
	$wp_customize->add_setting(
		'top_navigation_rating_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'top_navigation_rating_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'top_navigation_options',
			'label'    => __( 'Top navigation toggle star rating', 'klasse-theme' ),
		)
	);

	// Toggle slogan.
	$wp_customize->add_setting(
		'kls_top_navigation_slogan_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'kls_top_navigation_slogan_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'top_navigation_options',
			'label'    => __( 'Top navigation slogan toggle', 'klasse-theme' ),
		)
	);

	// Toggle custom text button.
	$wp_customize->add_setting(
		'kls_top_navigation_custom_text_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'kls_top_navigation_custom_text_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'top_navigation_options',
			'label'    => __( 'Top navigation custom text toggle', 'klasse-theme' ),
		)
	);

	// Seperator.
	$wp_customize->add_setting(
		'top_usps_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'top_usps_title',
			array(
				'priority' => 0,
				'section'  => 'top_navigation_options',
				'label'    => __( 'Usp settings', 'klasse-theme' ),
			)
		)
	);
	// Toggle usp's.
	$wp_customize->add_setting(
		'top_navigation_toggle_usps',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'top_navigation_toggle_usps',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'top_navigation_options',
			'label'    => __( 'Top navigation toggle usps', 'klasse-theme' ),
		)
	);
	// Toggle usp icon images.
	$wp_customize->add_setting(
		'top_navigation_toggle_usp_icon_images',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'top_navigation_toggle_usp_icon_images',
		array(
			'type'            => 'checkbox',
			'priority'        => 0,
			'section'         => 'top_navigation_options',
			'label'           => __( 'Top navigation toggle usp icon images', 'klasse-theme' ),
			'active_callback' => function() use ( $wp_customize ) {
				return 1 == $wp_customize->get_setting( 'top_navigation_toggle_usps' )->value();
			},
		)
	);
	// Change USP amount.
	$wp_customize->add_setting(
		'top_navigation_usp_amount',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'top_navigation_usp_amount',
		array(
			'type'            => 'text',
			'priority'        => 0,
			'section'         => 'top_navigation_options',
			'label'           => __( 'Change USP amount', 'klasse-theme' ),
			'active_callback' => function() use ( $wp_customize ) {
				return 1 == $wp_customize->get_setting( 'top_navigation_toggle_usps' )->value();
			},
		)
	);

	// Seperator.
	$wp_customize->add_setting(
		'kls_top_custom_button_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'kls_top_custom_button_title',
			array(
				'priority'        => 0,
				'section'         => 'top_navigation_options',
				'label'           => __( 'Custom button settings', 'klasse-theme' ),
				'active_callback' => function() use ( $wp_customize ) {
					return 1 == $wp_customize->get_setting( 'kls_top_navigation_custom_text_toggle' )->value();
				},
			)
		)
	);

	// Custom button text.
	$wp_customize->add_setting(
		'kls_top_navigation_custom_button_text',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'kls_top_navigation_custom_button_text',
		array(
			'type'            => 'text',
			'priority'        => 0,
			'section'         => 'top_navigation_options',
			'label'           => __( 'Custom button text', 'klasse-theme' ),
			'active_callback' => function() use ( $wp_customize ) {
				return 1 == $wp_customize->get_setting( 'kls_top_navigation_custom_text_toggle' )->value();
			},
		)
	);

	// Custom button text.
	$wp_customize->add_setting(
		'kls_top_navigation_custom_button_link',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'kls_top_navigation_custom_button_link',
		array(
			'type'            => 'text',
			'priority'        => 0,
			'section'         => 'top_navigation_options',
			'label'           => __( 'Custom button link', 'klasse-theme' ),
			'active_callback' => function() use ( $wp_customize ) {
				return 1 == $wp_customize->get_setting( 'kls_top_navigation_custom_text_toggle' )->value();
			},
		)
	);

	// Custom button icon.
	$wp_customize->add_setting(
		'kls_top_navigation_custom_button_icon',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'kls_top_navigation_custom_button_icon',
		array(
			'type'            => 'text',
			'priority'        => 0,
			'section'         => 'top_navigation_options',
			'label'           => __( 'Custom button icon', 'klasse-theme' ),
			'active_callback' => function() use ( $wp_customize ) {
				return 1 == $wp_customize->get_setting( 'kls_top_navigation_custom_text_toggle' )->value();
			},
		)
	);

	// Seperator.
	$wp_customize->add_setting(
		'top_fonts_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'top_fonts_title',
			array(
				'priority' => 0,
				'section'  => 'top_navigation_options',
				'label'    => __( 'Font settings', 'klasse-theme' ),
			)
		)
	);
	// Top navigation font size.
	$wp_customize->add_setting(
		'top_navigation_font_size',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'top_navigation_font_size',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'top_navigation_options',
			'label'    => __( 'Top navigation font size', 'klasse-theme' ),
		)
	);
	// Seperator.
	$wp_customize->add_setting(
		'top_colors',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'top_colors',
			array(
				'priority' => 0,
				'section'  => 'top_navigation_options',
				'label'    => __( 'Colors', 'klasse-theme' ),
			)
		)
	);
	// Top menu background color.
	$wp_customize->add_setting(
		'top_navigation_background_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'top_navigation_background_color',
			array(
				'label'        => __( 'Top navigation background color', 'klasse-theme' ),
				'section'      => 'top_navigation_options',
				'priority'     => 0,
				'show_opacity' => true,
			)
		)
	);
	// Top menu background color.
	$wp_customize->add_setting(
		'top_navigation_fixed_background_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'top_navigation_fixed_background_color',
			array(
				'label'        => __( 'Top navigation fixed background color', 'klasse-theme' ),
				'section'      => 'top_navigation_options',
				'priority'     => 0,
				'show_opacity' => true,
			)
		)
	);
	// Set top menu item color.
	$wp_customize->add_setting(
		'top_navigation_item_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'top_navigation_item_color',
			array(
				'label'        => __( 'Top navigation item color', 'klasse-theme' ),
				'section'      => 'top_navigation_options',
				'priority'     => 0,
				'show_opacity' => true,
			)
		)
	);
	// Set menu item active color.
	$wp_customize->add_setting(
		'top_navigation_item_active_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'top_navigation_item_active_color',
			array(
				'label'        => __( 'Top navigation item active color', 'klasse-theme' ),
				'section'      => 'top_navigation_options',
				'priority'     => 0,
				'show_opacity' => true,
			)
		)
	);
	// Menu item hover color.
	$wp_customize->add_setting(
		'top_navigation_item_hover_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'top_navigation_item_hover_color',
			array(
				'label'        => __( 'Top navigation item hover color', 'klasse-theme' ),
				'section'      => 'top_navigation_options',
				'priority'     => 0,
				'show_opacity' => true,
			)
		)
	);

	// Set top menu fixed item color.
	$wp_customize->add_setting(
		'top_navigation_fixed_item_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'top_navigation_fixed_item_color',
			array(
				'label'        => __( 'Fixed top navigation item color', 'klasse-theme' ),
				'section'      => 'top_navigation_options',
				'priority'     => 0,
				'show_opacity' => true,
			)
		)
	);
}
add_action( 'customize_register', 'kls_create_top_navigation_settings_controls' );
