<?php

/**
 * Create general 404 settings & controls
 *
 * @since 0.0.32
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_general_404_settings_controls( $wp_customize ) {
	// Seperator
	$wp_customize->add_setting(
		'theme_404_general_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'theme_404_general_title',
			array(
				'priority' => 0,
				'section'  => 'general_not_found_options',
				'label'    => __( 'General settings', 'klasse-theme' ),
			)
		)
	);
	// Change 404 theme version
	$wp_customize->add_setting(
		'theme_404_version',
		array(
			'default'   => '',
			// 'sanitize_callback' => 'sanitize_select_field',
			'transport' => 'refresh',
			'type'      => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		'theme_404_version',
		array(
			'priority' => 0,
			'type'     => 'select',
			'section'  => 'general_not_found_options',
			'label'    => __( '404 page theme selection', 'klasse-theme' ),
			'choices'  => $GLOBALS['kls_404'],
		)
	);
	// Select navigation type
	$wp_customize->add_setting(
		'theme_404_button_styling',
		array(
			'default'   => '',
			// 'sanitize_callback' => 'sanitize_select_field',
			'transport' => 'refresh',
			'type'      => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		'theme_404_button_styling',
		array(
			'priority' => 0,
			'type'     => 'select',
			'section'  => 'general_not_found_options',
			'label'    => __( '404 button styling', 'klasse-theme' ),
			'choices'  => $GLOBALS['kls_buttons'],
		)
	);
	// Toggle the search for the 404 page
	$wp_customize->add_setting(
		'404_search_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'404_search_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'general_not_found_options',
			'label'    => __( 'Toggle the search form', 'klasse-theme' ),
		)
	);
}
add_action( 'customize_register', 'kls_create_general_404_settings_controls' );
