<?php

/**
 * Create customizer panel
 *
 * @since 0.0.32
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_404_customizer_panels( $wp_customize ) {
	// Add the 404 panel
	$wp_customize->add_panel(
		'not_found_editor',
		array(
			'priority'    => 15,
			'title'       => __( '404 editor', 'klasse-theme' ),
			'description' => __( 'Edit the 404 page settings', 'klasse-theme' ),
		)
	);
}
add_action( 'customize_register', 'kls_create_404_customizer_panels' );

/**
 * Create customizer sections
 *
 * @since 0.0.32
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_404_customizer_sections( $wp_customize ) {
	// Add general woocommerce section
	$wp_customize->add_section(
		'general_not_found_options',
		array(
			'title'    => __( 'General Settings', 'klasse-theme' ),
			'priority' => '0',
			'panel'    => 'not_found_editor',
		)
	);
}
add_action( 'customize_register', 'kls_create_404_customizer_sections' );
/**
 * Require settings files
 *
 * @since 0.0.32
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
require_once __DIR__ . '/general-404-settings.php';
