<?php
/**
 * Create checkout page settings & controls
 *
 * @since 0.0.12
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_checkout_woocommerce_settings_controls( $wp_customize ) {
	// Seperator.
	$wp_customize->add_setting(
		'checkout_toggles_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'checkout_toggles_title',
			array(
				'priority' => 0,
				'section'  => 'checkout_woocommerce_options',
				'label'    => __( 'Toggleable items', 'klasse-theme' ),
			)
		)
	);

	// Toggle the menu.
	$wp_customize->add_setting(
		'checkout_menu_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'checkout_menu_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'checkout_woocommerce_options',
			'label'    => __( 'Disable the main menu on checkout', 'klasse-theme' ),
		)
	);

	// Toggle the footer.
	$wp_customize->add_setting(
		'checkout_footer_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'checkout_footer_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'checkout_woocommerce_options',
			'label'    => __( 'Disable the main footer on checkout', 'klasse-theme' ),
		)
	);

	// Toggle custom field order.
	$wp_customize->add_setting(
		'checkout_field_order_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'checkout_field_order_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'checkout_woocommerce_options',
			'label'    => __( 'Toggle the custom field order', 'klasse-theme' ),
		)
	);

	// Toggle the order notes.
	$wp_customize->add_setting(
		'checkout_notes_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'checkout_notes_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'checkout_woocommerce_options',
			'label'    => __( 'Disable the order notes', 'klasse-theme' ),
		)
	);

	// Toggle the default Payment method.
	$wp_customize->add_setting(
		'kls_checkout_default_payment_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_checkout_default_payment_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'checkout_woocommerce_options',
			'label'    => __( 'Disable the standard payment selection', 'klasse-theme' ),
		)
	);

	// Toggle the VAT field.
	$wp_customize->add_setting(
		'kls_checkout_toggle_vat_field',
		array(
			'default' => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport' => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_checkout_toggle_vat_field',
		array(
			'type' => 'checkbox',
			'priority' => 0,
			'section' => 'checkout_woocommerce_options',
			'label' => __('Toggle the VAT field', 'klasse-theme'),
		)
	);

	// Toggle the menu.
	$wp_customize->add_setting(
		'kls_checkout_toggle_vat_exempt',
		array(
			'default' => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport' => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_checkout_toggle_vat_exempt',
		array(
			'type' => 'checkbox',
			'priority' => 0,
			'section' => 'checkout_woocommerce_options',
			'label' => __('Toggle the VAT exempt for countries other thenthe default country', 'klasse-theme'),
		)
	);

	// Seperator
	$wp_customize->add_setting(
		'checkout_text_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'checkout_text_title',
			array(
				'priority' => 0,
				'section'  => 'checkout_woocommerce_options',
				'label'    => __( 'Text settings', 'klasse-theme' ),
			)
		)
	);

	// Seperator
	$wp_customize->add_setting(
		'kls_checkout_general_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'kls_checkout_general_title',
			array(
				'priority' => 0,
				'section'  => 'checkout_woocommerce_options',
				'label'    => __( 'General settings', 'klasse-theme' ),
			)
		)
	);

	// Select navigation type
	$wp_customize->add_setting(
		'kls_checkout_button_styling',
		array(
			'default'   => '',
			// 'sanitize_callback' => 'sanitize_select_field',
			'transport' => 'refresh',
			'type'      => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		'kls_checkout_button_styling',
		array(
			'priority' => 0,
			'type'     => 'select',
			'section'  => 'checkout_woocommerce_options',
			'label'    => __( 'Checkout button styling', 'klasse-theme' ),
			'choices'  => $GLOBALS['kls_buttons'],
		)
	);

	// Seperator
	$wp_customize->add_setting(
		'checkout_text_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'checkout_text_title',
			array(
				'priority' => 0,
				'section'  => 'checkout_woocommerce_options',
				'label'    => __( 'Text settings', 'klasse-theme' ),
			)
		)
	);

	// Change upsell products text.
	$wp_customize->add_setting(
		'checkout_login_message_text',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'checkout_login_message_text',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'checkout_woocommerce_options',
			'label'    => __( 'Change checkout login message text', 'klasse-theme' ),
		)
	);
}
add_action( 'customize_register', 'kls_create_checkout_woocommerce_settings_controls' );
