<?php

/**
 * Create general woocommerce settings & controls
 *
 * @since 0.0.11
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_general_woocommerce_settings_controls( $wp_customize ) {
	// Seperator
	$wp_customize->add_setting(
		'general_woocommerce_general_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'general_woocommerce_general_title',
			array(
				'priority' => 0,
				'section'  => 'general_woocommerce_options',
				'label'    => __( 'General settings', 'klasse-theme' ),
			)
		)
	);

	// Change Woocommerce theme version
	$wp_customize->add_setting(
		'general_theme_version',
		array(
			'default'   => '',
			// 'sanitize_callback' => 'sanitize_select_field',
			'transport' => 'refresh',
			'type'      => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		'general_theme_version',
		array(
			'priority' => 0,
			'type'     => 'select',
			'section'  => 'general_woocommerce_options',
			'label'    => __( 'Woocommerce theme selection', 'klasse-theme' ),
			'choices'  => array(
				'v1' => __( 'Version 1', 'klasse-theme' ),
				'v2' => __( 'Version 2', 'klasse-theme' ),
				'v3' => __( 'Version 3', 'klasse-theme' ),
				'v4' => __( 'Version 4', 'klasse-theme' ),
				'v5' => __( 'Version 5', 'klasse-theme' ),
				'v6' => __( 'Version 6', 'klasse-theme' ),
			),
		)
	);

	// Seperator
	$wp_customize->add_setting(
		'general_toggles_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'general_toggles_title',
			array(
				'priority' => 0,
				'section'  => 'general_woocommerce_options',
				'label'    => __( 'Toggleable items', 'klasse-theme' ),
			)
		)
	);

	// Disable standard Woocommerce styling
	$wp_customize->add_setting(
		'general_disable_standard_woocommerce_styling_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'general_disable_standard_woocommerce_styling_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'general_woocommerce_options',
			'label'    => __( 'Disable standard Woocommerce styling', 'klasse-theme' ),
		)
	);
	// Toggle menu cart
	$wp_customize->add_setting(
		'general_menu_cart_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'general_menu_cart_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'general_woocommerce_options',
			'label'    => __( 'Toggle the menu cart', 'klasse-theme' ),
		)
	);
	// Toggle menu wishlist
	$wp_customize->add_setting(
		'general_menu_wishlist_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'general_menu_wishlist_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'general_woocommerce_options',
			'label'    => __( 'Toggle the menu wishlist', 'klasse-theme' ),
		)
	);
	// Toggle menu my account
	$wp_customize->add_setting(
		'general_menu_my_account_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'general_menu_my_account_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'general_woocommerce_options',
			'label'    => __( 'Toggle the menu my account icon', 'klasse-theme' ),
		)
	);
	// Toggle HOT label
	$wp_customize->add_setting(
		'general_hot_label_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'general_hot_label_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'general_woocommerce_options',
			'label'    => __( 'Toggle "HOT" label', 'klasse-theme' ),
		)
	);
	// Toggle sales label
	$wp_customize->add_setting(
		'general_sales_label_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'general_sales_label_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'general_woocommerce_options',
			'label'    => __( 'Toggle "sales" label', 'klasse-theme' ),
		)
	);
	// Toggle sales label percentage
	$wp_customize->add_setting(
		'general_sales_label_percentage_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'general_sales_label_percentage_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'general_woocommerce_options',
			'label'    => __( 'Toggle sales label percentage', 'klasse-theme' ),
		)
	);
	// Toggle image zoom hover effect
	$wp_customize->add_setting(
		'general_image_zoom_effect_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'general_image_zoom_effect_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'general_woocommerce_options',
			'label'    => __( 'Toggle preview image hover effect', 'klasse-theme' ),
		)
	);

	// Seperator
	$wp_customize->add_setting(
		'general_text_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'general_text_title',
			array(
				'priority' => 0,
				'section'  => 'general_woocommerce_options',
				'label'    => __( 'Text settings', 'klasse-theme' ),
			)
		)
	);

	// Change HOT label text.
	$wp_customize->add_setting(
		'general_hot_label_text',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'general_hot_label_text',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'general_woocommerce_options',
			'label'    => __( 'Change "HOT" label text', 'klasse-theme' ),
		)
	);

	// Change related products text.
	$wp_customize->add_setting(
		'general_related_products_title_text',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'general_related_products_title_text',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'general_woocommerce_options',
			'label'    => __( 'Change "related products" title text', 'klasse-theme' ),
		)
	);

	// Change upsell products text.
	$wp_customize->add_setting(
		'general_upsell_products_title_text',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'general_upsell_products_title_text',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'general_woocommerce_options',
			'label'    => __( 'Change product upsell title text', 'klasse-theme' ),
		)
	);

	// Change recently viewed products text.
	$wp_customize->add_setting(
		'general_recently_viewed_products_title_text',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'general_recently_viewed_products_title_text',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'general_woocommerce_options',
			'label'    => __( 'Change product recently viewed title text', 'klasse-theme' ),
		)
	);
}
add_action( 'customize_register', 'kls_create_general_woocommerce_settings_controls' );
