<?php

/**
 * Create product archives page settings & controls
 *
 * @since 0.0.12
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_product_archives_woocommerce_settings_controls( $wp_customize ) {
	// Seperator.
	$wp_customize->add_setting(
		'kls_archive_general_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'kls_archive_general_title',
			array(
				'priority' => 0,
				'section'  => 'product_archive_woocommerce_options',
				'label'    => __( 'General settings', 'klasse-theme' ),
			)
		)
	);

	// Change checkoutflow theme version.
	$wp_customize->add_setting(
		'kls_archive_version',
		array(
			'default'   => '',
			// 'sanitize_callback' => 'sanitize_select_field',
			'transport' => 'refresh',
			'type'      => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		'kls_archive_version',
		array(
			'priority' => 0,
			'type'     => 'select',
			'section'  => 'product_archive_woocommerce_options',
			'label'    => __( 'Archive theme selection', 'klasse-theme' ),
			'choices'  => $GLOBALS['kls_archive_styling_versions'],
		)
	);

	// Seperator
	$wp_customize->add_setting(
		'archive_toggles_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'archive_toggles_title',
			array(
				'priority' => 0,
				'section'  => 'product_archive_woocommerce_options',
				'label'    => __( 'Toggleable items', 'klasse-theme' ),
			)
		)
	);

	// Toggle the sidebar
	$wp_customize->add_setting(
		'archive_sidebar_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'archive_sidebar_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'product_archive_woocommerce_options',
			'label'    => __( 'Toggle the sidebar', 'klasse-theme' ),
		)
	);

	// Toggle the sidebar not visible.
	$wp_customize->add_setting(
		'archive_sidebar_toggleable_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'archive_sidebar_toggleable_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'product_archive_woocommerce_options',
			'label'    => __( 'Toggle the sidebar toggleable', 'klasse-theme' ),
		)
	);

	// Toggle ajax filtering
	$wp_customize->add_setting(
		'archive_ajax_filter_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'archive_ajax_filter_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'product_archive_woocommerce_options',
			'label'    => __( 'Toggle ajax filtering', 'klasse-theme' ),
		)
	);
	// Toggle the price
	$wp_customize->add_setting(
		'archive_price_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'archive_price_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'product_archive_woocommerce_options',
			'label'    => __( 'Toggle price', 'klasse-theme' ),
		)
	);
	// Toggle the wishlist
	$wp_customize->add_setting(
		'archive_wishlist_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'archive_wishlist_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'product_archive_woocommerce_options',
			'label'    => __( 'Toggle wishlist', 'klasse-theme' ),
		)
	);
	// Toggle the quickview
	$wp_customize->add_setting(
		'archive_quickview_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'archive_quickview_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'product_archive_woocommerce_options',
			'label'    => __( 'Toggle QuickView', 'klasse-theme' ),
		)
	);
	// Toggle sidebar filter & category read more button
	$wp_customize->add_setting(
		'archive_filter_read_more_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'archive_filter_read_more_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'product_archive_woocommerce_options',
			'label'    => __( 'Toggle the read more button for Categories & filters', 'klasse-theme' ),
		)
	);

	// Toggle the quickview
	$wp_customize->add_setting(
		'kls_archive_show_sorting',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'kls_archive_show_sorting',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'product_archive_woocommerce_options',
			'label'    => __( 'Toggle the sorting dropdown', 'klasse-theme' ),
		)
	);

	// Archive description location.
	$wp_customize->add_setting(
		'kls_archive_description_location',
		array(
			'default'   => '',
			'transport' => 'refresh',
			'type'      => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		'kls_archive_description_location',
		array(
			'priority' => 0,
			'type'     => 'select',
			'section'  => 'product_archive_woocommerce_options',
			'label'    => __( 'Description location', 'klasse-theme' ),
			'choices'  => array(
				'top'    => __( 'Top', 'klasse-theme' ),
				'bottom' => __( 'Bottom', 'klasse-theme' ),
			),
		)
	);

	// Seperator
	$wp_customize->add_setting(
		'archive_amounts_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'archive_amounts_title',
			array(
				'priority' => 0,
				'section'  => 'product_archive_woocommerce_options',
				'label'    => __( 'Change amounts & texts', 'klasse-theme' ),
			)
		)
	);

	// Change products per page count
	$wp_customize->add_setting(
		'archive_products_per_page_count',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'archive_products_per_page_count',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'product_archive_woocommerce_options',
			'label'    => __( 'Change the amount of products per page', 'klasse-theme' ),
		)
	);

	// Change sidebar filter & categories amount
	$wp_customize->add_setting(
		'archive_filter_read_more_amount',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'archive_filter_read_more_amount',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'product_archive_woocommerce_options',
			'label'    => __( 'Change the amount of filters & categories per list', 'klasse-theme' ),
		)
	);
	// Change sidebar filter & categories amount
	$wp_customize->add_setting(
		'archive_filter_read_more_text',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'archive_filter_read_more_text',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'product_archive_woocommerce_options',
			'label'    => __( 'Change the read more button text for Categories & filters', 'klasse-theme' ),
		)
	);

	// Seperator.
	$wp_customize->add_setting(
		'kls_archive_banner_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'kls_archive_banner_title',
			array(
				'priority' => 0,
				'section'  => 'product_archive_woocommerce_options',
				'label'    => __( 'Archive banner settings', 'klasse-theme' ),
			)
		)
	);

	// Toggle Archive banner.
	$wp_customize->add_setting(
		'kls_archive_banner_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_archive_banner_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'product_archive_woocommerce_options',
			'label'    => __( 'Toggle the archive banner', 'klasse-theme' ),
		)
	);

	// Add custom Divi shortcode to top of product archive page.
	$divi_library_items_list         = array();
	$args                            = array( 'post_type' => 'et_pb_layout' );
	$divi_library_items              = get_posts( $args );
	$divi_library_items_list['none'] = __( 'None', 'klasse-theme' );

	foreach ( $divi_library_items as $divi_library_item ) {
		$divi_library_items_list[ $divi_library_item->ID ] = $divi_library_item->post_title;
	}

	$wp_customize->add_setting(
		'kls_header_archive_divi_shortcode_id',
		array(
			'default'   => '',
			// 'sanitize_callback' => 'sanitize_select_field',
			'transport' => 'refresh',
			'type'      => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		'kls_header_archive_divi_shortcode_id',
		array(
			'priority' => 0,
			'type'     => 'select',
			'section'  => 'product_archive_woocommerce_options',
			'label'    => __( 'Add custom Divi shortcode to the top of the page', 'klasse-theme' ),
			'choices'  => $divi_library_items_list,
		)
	);

	$wp_customize->add_setting(
		'kls_archive_banner_title_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_archive_banner_title_toggle',
		array(
			'type'            => 'checkbox',
			'priority'        => 0,
			'section'         => 'product_archive_woocommerce_options',
			'label'           => __( 'Toggle the title and breadcrumb', 'klasse-theme' ),
			'active_callback' => function() use ( $wp_customize ) {
				return 1 == $wp_customize->get_setting( 'kls_archive_banner_toggle' )->value();
			},
		)
	);

	// Archive banner padding.
	$wp_customize->add_setting(
		'kls_archive_banner_padding',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',

		)
	);

	$wp_customize->add_control(
		'kls_archive_banner_padding',
		array(
			'type'            => 'text',
			'priority'        => 0,
			'section'         => 'product_archive_woocommerce_options',
			'label'           => __( 'Archive banner padding', 'klasse-theme' ),
			'active_callback' => function() use ( $wp_customize ) {
				return 1 == $wp_customize->get_setting( 'kls_archive_banner_toggle' )->value();
			},
		)
	);

	// Archive banner background image.
	$wp_customize->add_setting(
		'kls_archive_banner_background_image',
		array(
			'default'   => '',
			// 'sanitize_callback' => '',
			'transport' => 'refresh',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Media_Control(
			$wp_customize,
			'kls_archive_banner_background_image',
			array(
				'label'           => __( 'Archive banner background image', 'klasse-theme' ),
				'priority'        => 0,
				'section'         => 'product_archive_woocommerce_options',
				'button_labels'   => array(
					'select'       => __( 'Select Image', 'klasse-theme' ),
					'change'       => __( 'Change Image', 'klasse-theme' ),
					'remove'       => __( 'Remove', 'klasse-theme' ),
					'default'      => __( 'Default', 'klasse-theme' ),
					'placeholder'  => __( 'No image selected', 'klasse-theme' ),
					'frame_title'  => __( 'Select Image', 'klasse-theme' ),
					'frame_button' => __( 'Choose Image', 'klasse-theme' ),
				),
				'active_callback' => function() use ( $wp_customize ) {
					return 1 == $wp_customize->get_setting( 'kls_archive_banner_toggle' )->value();
				},
			)
		)
	);

	// Archive banner background color.
	$wp_customize->add_setting(
		'kls_archive_banner_background_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'kls_archive_banner_background_color',
			array(
				'label'           => __( 'Archive banner background color', 'klasse-theme' ),
				'section'         => 'product_archive_woocommerce_options',
				'priority'        => 0,
				'show_opacity'    => true,
				'active_callback' => function() use ( $wp_customize ) {
					return 1 == $wp_customize->get_setting( 'kls_archive_banner_toggle' )->value();
				},
			)
		)
	);

	// Archive banner color.
	$wp_customize->add_setting(
		'kls_archive_banner_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'kls_archive_banner_color',
			array(
				'label'           => __( 'Archive banner color', 'klasse-theme' ),
				'section'         => 'product_archive_woocommerce_options',
				'priority'        => 0,
				'show_opacity'    => true,
				'active_callback' => function() use ( $wp_customize ) {
					return 1 == $wp_customize->get_setting( 'kls_archive_banner_toggle' )->value();
				},
			)
		)
	);

	// Seperator.
	$wp_customize->add_setting(
		'archive_divi_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'archive_divi_title',
			array(
				'priority' => 0,
				'section'  => 'product_archive_woocommerce_options',
				'label'    => __( 'Divi module', 'klasse-theme' ),
			)
		)
	);

	// Add custom Divi shortcode to bottom of product page
	$wp_customize->add_setting(
		'archive_add_divi_shortcode_id',
		array(
			'default'   => '',
			// 'sanitize_callback' => 'sanitize_select_field',
			'transport' => 'refresh',
			'type'      => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		'archive_add_divi_shortcode_id',
		array(
			'priority' => 0,
			'type'     => 'select',
			'section'  => 'product_archive_woocommerce_options',
			'label'    => __( 'Add custom Divi shortcode to the bottom of the page', 'klasse-theme' ),
			'choices'  => $divi_library_items_list,
		)
	);
}
add_action( 'customize_register', 'kls_create_product_archives_woocommerce_settings_controls' );
