<?php

/**
 * Create product menu page settings & controls
 *
 * @since 0.1.74
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_product_menu_woocommerce_settings_controls( $wp_customize ) {
	// Seperator.
	$wp_customize->add_setting(
		'kls_product_menu_toggles_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'kls_product_menu_toggles_title',
			array(
				'priority' => 0,
				'section'  => 'product_menu_woocommerce_options',
				'label'    => __( 'Toggleable items', 'klasse-theme' ),
			)
		)
	);
	// Toggle the product menu.
	$wp_customize->add_setting(
		'kls_product_menu_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'kls_product_menu_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'product_menu_woocommerce_options',
			'label'    => __( 'Toggle the product menu', 'klasse-theme' ),
		)
	);

	// Toggle the product menu.
	$wp_customize->add_setting(
		'kls_product_menu_showcase_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'kls_product_menu_showcase_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'product_menu_woocommerce_options',
			'label'    => __( 'Toggle the product showcase on the rightside of the menu', 'klasse-theme' ),
		)
	);

	// Toggle the product menu.
	$wp_customize->add_setting(
		'kls_product_menu_empty_categories_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'kls_product_menu_empty_categories_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'product_menu_woocommerce_options',
			'label'    => __( 'Hide the empty categories', 'klasse-theme' ),
		)
	);

	// Exclude specific product category id's.
	$wp_customize->add_setting(
		'kls_product_menu_exclude_ids',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'kls_product_menu_exclude_ids',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'product_menu_woocommerce_options',
			'label'    => __( 'Categorie ids to exclude', 'klasse-theme' ),
		)
	);

	// Change the
	$wp_customize->add_setting(
		'kls_product_menu_submenu_version',
		array(
			'default'   => '',
			// 'sanitize_callback' => 'sanitize_select_field',
			'transport' => 'refresh',
			'type'      => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		'kls_product_menu_submenu_version',
		array(
			'priority'    => 0,
			'type'        => 'select',
			'section'     => 'product_menu_woocommerce_options',
			'label'       => __( 'Product submenu styling', 'klasse-theme' ),
			'description' => __( 'This changes the look for the product menu submenu with the head categories.', 'klasse-theme' ),
			'choices'     => array(
				'wide-menu' => 'Wide menu',
				'side-menu' => 'Side menu',
				'basic-menu' => 'Basic menu',
			),
		)
	);

	// Maximum amount of products in the categorie
	$wp_customize->add_setting(
		'kls_product_menu_max_products',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'kls_product_menu_max_products',
		array(
			'type'        => 'text',
			'priority'    => 0,
			'section'     => 'product_menu_woocommerce_options',
			'description' => __( 'Set to 0 to show all the items.', 'klasse-theme' ),
			'label'       => __( 'Max amount of products', 'klasse-theme' ),
		)
	);
}
add_action( 'customize_register', 'kls_create_product_menu_woocommerce_settings_controls' );
