<?php

/**
 * Create SyncSilo page settings & controls
 *
 * @since 0.1.04
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_syncsilo_woocommerce_settings_controls( $wp_customize ) {
	// Seperator
	$wp_customize->add_setting(
		'syncsilo_toggles_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'syncsilo_toggles_title',
			array(
				'priority' => 0,
				'section'  => 'syncsilo_woocommerce_options',
				'label'    => __( 'Toggleable items', 'klasse-theme' ),
			)
		)
	);

	// Toggle "configure now" text
	$wp_customize->add_setting(
		'syncsilo_configure_now_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'syncsilo_configure_now_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'syncsilo_woocommerce_options',
			'label'    => __( 'Toggle "configure now" text under configurable products', 'klasse-theme' ),
		)
	);
}
add_action( 'customize_register', 'kls_create_syncsilo_woocommerce_settings_controls' );
