<?php

/**
 * Create customizer panel
 *
 * @since 0.0.11
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_woocommerce_customizer_panels( $wp_customize ) {
	// Add the woocommerce panel
	$wp_customize->add_panel(
		'woocommerce_editor',
		array(
			'priority'    => 15,
			'title'       => __( 'Woocommerce editor', 'klasse-theme' ),
			'description' => __( 'Edit the woocommerce settings', 'klasse-theme' ),
		)
	);
}
add_action( 'customize_register', 'kls_create_woocommerce_customizer_panels' );

/**
 * Create customizer sections
 *
 * @since 0.0.11
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_woocommerce_customizer_sections( $wp_customize ) {
	// Add general woocommerce section
	$wp_customize->add_section(
		'general_woocommerce_options',
		array(
			'title'    => __( 'General Settings', 'klasse-theme' ),
			'priority' => '0',
			'panel'    => 'woocommerce_editor',
		)
	);
	// Add checkout flow woocommerce section
	$wp_customize->add_section(
		'checkout_flow_woocommerce_options',
		array(
			'title'    => __( 'Checkout flow settings', 'klasse-theme' ),
			'priority' => '0',
			'panel'    => 'woocommerce_editor',
		)
	);
	// Add cart woocommerce section
	$wp_customize->add_section(
		'cart_woocommerce_options',
		array(
			'title'    => __( 'Cart page settings', 'klasse-theme' ),
			'priority' => '0',
			'panel'    => 'woocommerce_editor',
		)
	);
	// Add mini cart woocommerce section
	$wp_customize->add_section(
		'mini_cart_woocommerce_options',
		array(
			'title'    => __( 'Mini cart settings', 'klasse-theme' ),
			'priority' => '0',
			'panel'    => 'woocommerce_editor',
		)
	);
	// Add checkout woocommerce section
	$wp_customize->add_section(
		'checkout_woocommerce_options',
		array(
			'title'    => __( 'Checkout page settings', 'klasse-theme' ),
			'priority' => '0',
			'panel'    => 'woocommerce_editor',
		)
	);
	// Add product archive woocommerce section
	$wp_customize->add_section(
		'product_archive_woocommerce_options',
		array(
			'title'    => __( 'Product archive settings', 'klasse-theme' ),
			'priority' => '0',
			'panel'    => 'woocommerce_editor',
		)
	);
	// Add product page woocommerce section
	$wp_customize->add_section(
		'product_page_woocommerce_options',
		array(
			'title'    => __( 'Product page settings', 'klasse-theme' ),
			'priority' => '0',
			'panel'    => 'woocommerce_editor',
		)
	);
	// Add wishlist woocommerce section
	$wp_customize->add_section(
		'wishlist_woocommerce_options',
		array(
			'title'    => __( 'Wishlist settings', 'klasse-theme' ),
			'priority' => '0',
			'panel'    => 'woocommerce_editor',
		)
	);
	// Add my account woocommerce section
	$wp_customize->add_section(
		'my_account_woocommerce_options',
		array(
			'title'    => __( 'My Account settings', 'klasse-theme' ),
			'priority' => '0',
			'panel'    => 'woocommerce_editor',
		)
	);
	// Add product menu woocommerce section
	$wp_customize->add_section(
		'product_menu_woocommerce_options',
		array(
			'title'    => __( 'Product menu settings', 'klasse-theme' ),
			'priority' => '0',
			'panel'    => 'woocommerce_editor',
		)
	);
	// Add syncsilo woocommerce section
	if ( get_option( 'kls_syncsilo_compatibility_toggle' ) == 'on' ) :
		$wp_customize->add_section(
			'syncsilo_woocommerce_options',
			array(
				'title'    => __( 'SyncSilo settings', 'klasse-theme' ),
				'priority' => '0',
				'panel'    => 'woocommerce_editor',
			)
		);
	endif;
}
add_action( 'customize_register', 'kls_create_woocommerce_customizer_sections' );
/**
 * Require settings files
 *
 * @since 0.0.12
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
require_once __DIR__ . '/general-settings.php';
require_once __DIR__ . '/checkout-flow-settings.php';
require_once __DIR__ . '/cart-settings.php';
require_once __DIR__ . '/mini-cart-settings.php';
require_once __DIR__ . '/checkout-settings.php';
require_once __DIR__ . '/product-archive-settings.php';
require_once __DIR__ . '/product-page-settings.php';
require_once __DIR__ . '/wishlist-settings.php';
require_once __DIR__ . '/my-account-settings.php';
require_once __DIR__ . '/syncsilo-settings.php';
require_once __DIR__ . '/product-menu-settings.php';
