<?php // phpcs:ignore
/**
 * FAQ Shortcodes class
 *
 * @category   Klasse_Theme
 * @package    KT
 * @subpackage KT/includes/faq
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.1.79
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
	exit;
}

if (!class_exists('KT_Faq_Shortcodes')) {
	/**
	 * FAQ Shortcodes class
	 *
	 * @category    Klasse_Theme
	 * @package     KT
	 * @subpackage  KT/includes/faq
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.1.79
	 */
	class KT_Faq_Shortcodes
	{
		/**
		 * Construct the FAQ Shortcodes.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.1.79
		 */
		public function __construct()
		{
			add_shortcode('faq_module', array($this, 'faqModule'));
			add_shortcode('faq_search', array($this, 'faqSearch'));

			add_action('wp_ajax_search_custom_post_type', array($this, 'faqSearchPosts'));
			add_action('wp_ajax_nopriv_search_custom_post_type', array($this, 'faqSearchPosts'));
		}

		/**
		 * FAQ Module shortcode
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.79
		 * 
		 * Todo, category ID. Only show faq's by that category.
		 */
		public function faqModule($atts)
		{
			$columns = isset($atts['columns']) ? $atts['columns'] : '2';
			$classes = isset($atts['class']) ? $atts['class'] : '';
			$term_id = isset($atts['term_id']) ? $atts['term_id'] : '';

			$terms = get_terms(
				array(
					'taxonomy' => 'faq_category',
					'hide_empty' => true,
				)
			);

			ob_start();
			get_template_part(
				'/template-parts/faq/content',
				null,
				array(
					'terms' => $terms,
					'columns' => $columns,
					'classes' => $classes,
					'term_id' => $term_id,
				)
			);
			return ob_get_clean();
		}

		public function faqSearch()
		{
			$items = get_posts([
				'post_type' => 'faq',
				'post_status' => 'publish',
				'numberposts' => -1,
				'order' => 'ASC'
			]);

			ob_start();
			get_template_part(
				'/template-parts/faq/search',
				null,
				array(
					'items' => $items,
				)
			);
			return ob_get_clean();
		}

		public function faqSearchPosts()
		{
			$search_term = $_POST['term'];
			$args = array(
				'post_type' => 'faq',
				'posts_per_page' => -1,
				's' => $search_term,
			);

			$query = new WP_Query($args);

			echo '<h3 class="faq-search-results-title">' . __('Search results:', 'klasse-theme') . '</h3>';

			if ($query->have_posts()):
				while ($query->have_posts()):
					$query->the_post();
					ob_start();
					get_template_part(
						'/template-parts/faq/item',
						null,
						array(
							'title' => get_the_title(),
							'content' => get_the_content(),
						)
					);
					echo ob_get_clean();
				endwhile;
			else:
				echo '<li>' . __('No results found.', 'klasse-theme') . '</li>';
			endif;

			die();
		}

	}

	new KT_Faq_Shortcodes();
}