<?php
/**
 * Divi alt tag fix
 *
 * @since 0.0.03
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * // [Dev] Todo, fix this.
 */
// Image alt fix inject
function kls_get_image_alt( $image_url ) {
	if ( ! $image_url ) {
		return '';
	}

	if ( '/' === $image_url[0] ) {
		$post_id = attachment_url_to_postid( home_url() . $image_url );
	} else {
		$post_id = attachment_url_to_postid( $image_url );
	}

	$alt_text = get_post_meta( $post_id, '_wp_attachment_image_alt', true );
	if ( '' === $alt_text ) {
		$alt_text = get_the_title( $post_id );
	}

	return $alt_text;
}

/* Fix alt text for image modules */
function kls_update_alt( $attrs, $unprocessed_attrs, $slug ) {
	if ( ( $slug === 'et_pb_image' || $slug === 'et_pb_fullwidth_image' ) && isset( $attrs['alt'] ) && '' === $attrs['alt'] ) {
		$attrs['alt'] = kls_get_image_alt( $attrs['src'] );
	}
	// elseif($slug === 'et_pb_blurb' && 'off' === $attrs['use_icon'] && '' === $attrs['alt'])
	// $attrs['alt'] = kls_get_image_alt($attrs['image']);
	// elseif ($slug === 'et_pb_slide' && '' !== $attrs['image'] && '' === $attrs['image_alt'])
	// $attrs['image_alt'] = kls_get_image_alt( $attrs['image'] );
	elseif ( $slug === 'et_pb_fullwidth_header' ) {
		if ( '' !== $attrs['logo_image_url'] && '' === $attrs['logo_alt_text'] ) {
			$attrs['logo_alt_text'] = kls_get_image_alt( $attrs['logo_image_url'] );
		}
		if ( '' !== $attrs['header_image_url'] && '' === $attrs['image_alt_text'] ) {
			$attrs['image_alt_text'] = kls_get_image_alt( $attrs['header_image_url'] );
		}
	}
	return $attrs;
}

add_filter( 'et_pb_module_shortcode_attributes', 'kls_update_alt', 20, 3 );
