<?php

/**
 * Action bar settings
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 * [Dev] Todo, the min and max width interferes on tabbled because it overlaps.
 */

$css_combined[] = '
    #klsactionbar .kls-actionbar-container .kls-actionbar-content {max-width:' . get_theme_mod( 'content_max_width' ) . '; width: 90% !important;margin: 0 auto;}

    #klsactionbar .kls-actionbar-container, .close-actionbar i{background-color: ' . get_option( 'kls_action_bar_background_color' ) . ';}
    #klsactionbar .kls-actionbar-container, .close-actionbar i{color:' . get_option( 'kls_action_bar_text_color' ) . ';}

    @media (max-width:' . get_theme_mod( 'navigation_breakpoint' ) . '){
        .kls-actionbar-content{
            flex-direction: column;
            text-align: center;
            font-size: 14px;
        }

        .kls-actionbar-text{
            margin-bottom: 10px;
        }

        .kls-actionbar-text,
        .kls-actionbar-button {
            -webkit-box-pack: center;
            -webkit-justify-content: center;
            -moz-box-pack: center;
            -ms-flex-pack: center;
            justify-content: center;
        }
    }
';
if ( get_option( 'kls_action_bar_close_button_location' ) == 'Left' ) :
	$css_combined[] = '
    .close-button-container{
        left: 20px !important;
    }
    @media (max-width:' . get_theme_mod( 'navigation_breakpoint' ) . '){
        .kls-actionbar-text,
        .kls-actionbar-button {
            padding-left: 40px !important;
            padding-right: 0 !important;
        }
        .close-button-container{
            left: 10px !important;
        }
    }';
else :
	$css_combined[] = '
    .close-button-container{
        right: 20px !important;
    }
    @media (max-width:' . get_theme_mod( 'navigation_breakpoint' ) . '){
        .kls-actionbar-text,
        .kls-actionbar-button {
            padding-right: 40px !important;
            padding-left: 0 !important;
        }
        .close-button-container{
            right: 10px !important;
        }
    }';
endif;
/**
 * Mobile navigation position
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if ( get_theme_mod( 'mobile_navigation_position' ) == 'bottom' ) :
	$css_combined[]  = '
        @media (max-width:' . get_theme_mod( 'navigation_breakpoint' ) . '){
            #klsactionbar{
                top: 0;
            }

            #klsactionbar.minimized{
                top: -300px !important;
                bottom: auto !important;
            }

            .minimized .close-button-container{
                top: 10px !important;
            }
        }
    ';
	$css_combined [] = '@media (min-width: ' . get_theme_mod( 'navigation_breakpoint' ) . '){';
else :
	$css_combined[] = '
        .minimized .close-button-container{
            bottom: 10px !important;
        }
    ';
endif;
$css_combined [] = '
    #klsactionbar{
        bottom: -1px;
    }

    #klsactionbar.minimized {
        top: auto !important;
        bottom: -300px;
    }

    .minimized .close-button-container{
        bottom: 10px !important;
    }
';
if ( get_theme_mod( 'mobile_navigation_position' ) == 'bottom' ) :
	$css_combined[] = '}';
endif;
