<?php

/**
 * Button settings
 *
 * @since 0.1.39
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
foreach ( array_keys( $GLOBALS['kls_buttons'] ) as $button ) :
	// Colors
	$css_combined[] = '
        .theme-button.theme-button-' . $button . ',
        .menu-button.menu-button-' . $button . '>a 
        ' . ( get_theme_mod('form_submit_button_style', 'primary') == $button ? ', body .nf-element[type="button"], body .nf-element[type="submit"], body .gform_button[type="submit"]' : '' ) . ' {
            background-color: ' . get_theme_mod( 'button_' . $button . '_background_color' ) . ' !important;
            color: ' . get_theme_mod( 'button_' . $button . '_color' ) . ' !important;
            border-color: ' . get_theme_mod( 'button_' . $button . '_border_color' ) . ' !important;
            border-width: ' . get_theme_mod( 'button_' . $button . '_border_size' ) . ' !important;
            border-radius: ' . get_theme_mod( 'button_' . $button . '_border_radius' ) . ' !important;
            -webkit-border-radius: ' . get_theme_mod( 'button_' . $button . '_border_radius' ) . ' !important;
            -moz-border-radius: ' . get_theme_mod( 'button_' . $button . '_border_radius' ) . ' !important;
            -ms-border-radius: ' . get_theme_mod( 'button_' . $button . '_border_radius' ) . ' !important;
            -o-border-radius: ' . get_theme_mod( 'button_' . $button . '_border_radius' ) . ' !important;
        }

        @media (hover:hover) and (pointer:fine){
            .theme-button.theme-button-' . $button . ':hover,
            .menu-button-' . $button . '>a:hover 
            ' . ( get_theme_mod('form_submit_button_style', 'primary') == $button ? ', body .nf-element[type="button"]:hover, body .nf-element[type="submit"]:hover, body .gform_button[type="submit"]:hover' : '' ) . ' {
                background-color: ' . get_theme_mod( 'button_' . $button . '_hover_background_color' ) . ' !important;
                color: ' . get_theme_mod( 'button_' . $button . '_hover_color' ) . ' !important;
                border-color: ' . get_theme_mod( 'button_' . $button . '_hover_border_color' ) . ' !important;
                text-decoration: none;
            }
        }
    ';

	// Text settings
	$css_combined[] = '
        .theme-button.theme-button-' . $button . ',
        .menu-button.menu-button-' . $button . '>a
        ' . ( get_theme_mod('form_submit_button_style', 'primary') == $button ? ', body .nf-element[type="button"], body .nf-element[type="submit"], body .gform_button[type="submit"]' : '' ) . ' {
            font-weight: ' . get_theme_mod( 'button_' . $button . '_font_weight', 'bold' ) . ' !important;
            letter-spacing: ' . get_theme_mod( 'button_' . $button . '_letter_spacing', '0px' ) . ' !important;
            line-height: ' . get_theme_mod( 'button_' . $button . '_line_height', '1.7em' ) . ' !important;
            text-transform: ' . get_theme_mod( 'button_' . $button . '_text_transform', 'none' ) . ' !important;
            padding: ' . get_theme_mod( 'button_' . $button . '_padding', '10px 30px' ) . ' !important;
        }

        .theme-button.theme-button-' . $button . '
        ' . ( get_theme_mod('form_submit_button_style', 'primary') == $button ? ', body .nf-element[type="button"], body .nf-element[type="submit"], body .gform_button[type="submit"]' : '' ) . ' {
            font-size: ' . get_theme_mod( 'button_' . $button . '_font_size', '14px' ) . ' !important;
        }

        .menu-buttons-container>.theme-button.theme-button-' . $button . ' {
            font-size: ' . get_theme_mod( 'button_' . $button . '_font_size', '16px' ) . ' !important;
        }
    ';

	// Icon settings
	if ( get_theme_mod( 'button_' . $button . '_icon_code' ) ) :
		// Standard
		$css_combined[] = '
            body .theme-button-' . $button . '::before,
            body .theme-button-' . $button . '::after,
            body.woocommerce-page a.theme-button-' . $button . '::before,
            body.woocommerce-page a.theme-button-' . $button . '::after,
            .menu-button.menu-button-' . $button . '>a::before,
            .menu-button.menu-button-' . $button . '>a::after  {
                font-family: "Font Awesome 5 Free" !important;
                font-weight: ' . get_theme_mod( 'button_' . $button . '_icon_font_weight', 'bold' ) . ' !important;
                line-height: ' . get_theme_mod( 'button_' . $button . '_line_height', '1.7em' ) . ' !important;
            }

            .theme-button.theme-button-' . $button . ',
            .menu-button.menu-button-' . $button . '>a {
                position: relative !important;
            }
        ';

		// Icon position
		if ( get_theme_mod( 'button_' . $button . '_icon_position' ) == 'left-text' || get_theme_mod( 'button_' . $button . '_icon_position' ) == 'left-full' ) :
			$css_combined[] = '
                .theme-button-' . $button . '::before,
                .menu-button.menu-button-' . $button . '>a::before {
                    content:"' . '\\' . get_theme_mod( 'button_' . $button . '_icon_code' ) . '";
                }
            ';
			// Left to the text
			if ( get_theme_mod( 'button_' . $button . '_icon_position' ) == 'left-text' ) :
				$css_combined[] = '
                    .theme-button-' . $button . '::before,
                    .menu-button.menu-button-' . $button . '>a::before {
                        margin-right: 5px;
                    }
                ';
				// Fully left of the button itself
			elseif ( get_theme_mod( 'button_' . $button . '_icon_position' ) == 'left-full' ) :
				$css_combined[] = '
                    .theme-button-' . $button . '::before,
                    .menu-button.menu-button-' . $button . '>a::before {
                        left: 30px;
                        position: absolute;
                    }

                    .theme-button.theme-button-' . $button . ',
                    .menu-button.menu-button-' . $button . '>a {
                        padding-left: 60px !important;
                    }
                ';
			endif;
		else :
			$css_combined[] = '
                .theme-button-' . $button . '::after,
                .menu-button.menu-button-' . $button . '>a::after {
                    content:"' . '\\' . get_theme_mod( 'button_' . $button . '_icon_code' ) . '";
                }
            ';
			// Right to the text
			if ( get_theme_mod( 'button_' . $button . '_icon_position' ) == 'right-text' ) :
				$css_combined[] = '
                    .theme-button-' . $button . '::after,
                    .menu-button.menu-button-' . $button . '>a::after {
                        margin-left: 5px;
                    }
                ';
				// Fully right of the button itself
			elseif ( get_theme_mod( 'button_' . $button . '_icon_position' ) == 'right-full' ) :
				$css_combined[] = '
                    .theme-button-' . $button . '::after,
                    .menu-button.menu-button-' . $button . '>a::after {
                        right: 30px;
                        position: absolute;
                    }

                    .theme-button.theme-button-' . $button . ',
                    .menu-button.menu-button-' . $button . '>a {
                        padding-right: 60px !important;
                    }
                ';
			endif;
		endif;
	endif;
endforeach;
