<?php

/**
 * Add color variables
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.57
 */
$css_combined[] = '
	:root {
		--kls-primary-color:' . get_theme_mod( 'primary_color' ) . ';
		--kls-secundary-color:' . get_theme_mod( 'secundary_color' ) . ';
		--kls-tertiary-color:' . get_theme_mod( 'tertiary_color' ) . ';
		--kls-heading-color:' . get_theme_mod( 'heading_text_color' ) . ';
		--kls-body-color:' . get_theme_mod( 'body_text_color' ) . ';
		--kls-light-background-color:' . get_theme_mod( 'background_light_color' ) . ';
	}
	.theme-primary-color{color:' . get_theme_mod( 'primary_color' ) . '!important;}
	.theme-primary-background-color{background-color:' . get_theme_mod( 'primary_color' ) . '!important;}
	.theme-primary-border-color{border-color:' . get_theme_mod( 'primary_color' ) . '!important;}

	.theme-secundary-color{color:' . get_theme_mod( 'secundary_color' ) . '!important;}
	.theme-secundary-background-color{background-color:' . get_theme_mod( 'secundary_color' ) . '!important;}
	.theme-secundary-border-color{border-color:' . get_theme_mod( 'secundary_color' ) . '!important;}

	.theme-tertiary-color{color:' . get_theme_mod( 'tertiary_color' ) . '!important;}
	.theme-tertiary-background-color{background-color:' . get_theme_mod( 'tertiary_color' ) . '!important;}
	.theme-tertiary-border-color{border-color:' . get_theme_mod( 'tertiary_color' ) . '!important;}
';

/**
 * Button color settings
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
$css_combined[] = '
	body, button, input, select, textarea, .ywgc_enter_code p {color: ' . get_theme_mod( 'body_text_color' ) . ';}

	h1, h2, h3, h4, h5, h6, body #et-boc .et-l h1, body #et-boc .et-l h2, body #et-boc .et-l h3, body #et-boc .et-l h4, body #et-boc .et-l h5, body #et-boc .et-l h6  {color: ' . get_theme_mod( 'heading_text_color' ) . '}
';

/**
 * Link button color settings
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
$css_combined[] = '
	.button-link,.breadcrumb a,.woocommerce-remove-coupon, .account-orders-table td a, .account-navigation li a, .account-dashboard-text-wrapper a, .download-product a, .woocommerce-privacy-policy-text a, .woocommerce-terms-and-conditions-link, .order_details .product-name a  .yith-wcwl-share li a,
	.wishlist-items-wrapper a, header .main-nav li.mini_cart_item a, .ywgc-show-giftcard, .ywgc-remove-gift-card,.order_details .product-name a, .ywgc-view-order,
	.social-icon,
	.yith-wcwl-share li a,
	.not_found-menu-container a,
	.woocommerce-product-gallery ul.flex-direction-nav li a {color: ' . get_theme_mod( 'button_link_color' ) . ' !important;}

	.woocommerce-product-gallery .flex-control-paging li a.flex-active::after {background-color: ' . get_theme_mod( 'button_link_color' ) . '}

	@media(hover:hover) and (pointer:fine){
		.button-link:hover,.breadcrumb a:hover,.woocommerce-remove-coupon:hover, .account-orders-table td a:hover, .account-navigation li a:hover, .account-dashboard-text-wrapper a:hover, .download-product a:hover, .woocommerce-privacy-policy-text a:hover, .woocommerce-terms-and-conditions-link:hover, .yith-wcwl-share li a:hover,
		.wishlist-items-wrapper a:hover, header .main-nav li.mini_cart_item a:hover,
		.ywgc-show-giftcard:hover,
		.ywgc-remove-gift-card:hover,
		.order_details .product-name a:hover,
		.ywgc-view-order:hover,
		.social-icon:hover,
		.yith-wcwl-share li a:hover,
		.not_found-menu-container a:hover {color: ' . get_theme_mod( 'button_link_hover_color' ) . '}
	}
';

/**
 * Primary button color settings
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
$css_combined[] = '
	body .mini-cart-empty-button,
	body .woocommerce-mini-cart__buttons .button,
	body .single_add_to_cart_button,
	body .wishlist-items-wrapper .add_to_cart_button,
	body .widget .yith-wcan-reset-navigation,
	body .yith-wcqv-button,
	body body.et-db #et-boc .et-l .et_pb_module .yith-wcqv-button,
	body .comment-form .form-submit input.submit,
	body .update-cart-button:not(:disabled),
	body .woocommerce-pagination ul li .current {
		background-color: ' . get_theme_mod( 'button_primary_background_color' ) . ' !important;
		color: ' . get_theme_mod( 'button_primary_color' ) . ' !important;
		border-color: ' . get_theme_mod( 'button_primary_border_color' ) . ' !important;
		border-width: ' . get_theme_mod( 'button_primary_border_size' ) . ' !important;
		border-radius: ' . get_theme_mod( 'button_primary_border_radius' ) . ' !important;
		cursor: pointer !important;
	}

	@media(hover:hover) and (pointer:fine){
		.woocommerce-pagination ul li a:hover,
		.woocommerce-pagination ul li span:hover,
		.woocommerce-pagination ul li .current {
			background-color: ' . get_theme_mod( 'button_primary_background_color' ) . ';
			color: ' . get_theme_mod( 'button_primary_color' ) . ';
			border-color: ' . get_theme_mod( 'button_primary_border_color' ) . ';
		}

		.mini-cart-empty-button:hover,
		.woocommerce-mini-cart__buttons .button:hover,
		.single_add_to_cart_button:hover,
		.wishlist-items-wrapper .add_to_cart_button:hover,
		.widget .yith-wcan-reset-navigation:hover,
		.yith-wcqv-button:hover,
		body.et-db #et-boc .et-l .et_pb_module .yith-wcqv-button:hover,
		.comment-form .form-submit input.submit:hover,
		.update-cart-button:not(:disabled):hover {
			background-color: ' . get_theme_mod( 'button_primary_hover_background_color' ) . ' !important;
			color: ' . get_theme_mod( 'button_primary_hover_color' ) . ' !important;
			border-color: ' . get_theme_mod( 'button_primary_hover_border_color' ) . ' !important;
			text-decoration: none;
		}
	}

	.woocommerce-pagination ul li a,
	.woocommerce-pagination ul li span {
		background-color: ' . get_theme_mod( 'button_primary_hover_background_color' ) . ';
		color: ' . get_theme_mod( 'button_primary_hover_color' ) . ';
		border-color: ' . get_theme_mod( 'button_primary_hover_border_color' ) . ';
		text-decoration: none;
	}
';
/**
 * Secundary button color settings
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
$css_combined[] = '
	body .summary .variations .reset_variations,
	body .syncsilo_upload,
	body .motiflow_pattern,
	body .woocommerce-account-content .theme-button.button,
	#kls-login_form input[type="submit"],
	#kls-login_form.logout a,
	.order-again .button,
	body .woocommerce-MyAccount-downloads-file,
	body .price_slider_amount .button,
	body .wishlist-title-with-form .button,
	body .sidebar-toggle,
	body .widget_layered_nav_filters li a,
	body .ywgc_apply_gift_card_button,
	body .product-item-wrapper .product-item-links .button,
	body .woocommerce-wishlist .product-item-wrapper .product-item-links a {
		background: ' . get_theme_mod( 'button_secundary_background_color' ) . ' !important;
		color: ' . get_theme_mod( 'button_secundary_color' ) . ' !important;
		border-color: ' . get_theme_mod( 'button_secundary_border_color' ) . ' !important;
		border-width: ' . get_theme_mod( 'button_secundary_border_size' ) . ' !important;
		border-radius: ' . get_theme_mod( 'button_secundary_border_radius' ) . ' !important;
	}

	@media(hover:hover) and (pointer:fine){
		.summary .variations .reset_variations:hover,
		.woocommerce-account-content .theme-button.button:hover,
		#kls-login_form input[type="submit"]:hover,
		#kls-login_form.logout a:hover,
		body .syncsilo_upload:hover,
		body .motiflow_pattern:hover,
		.order-again .button:hover,
		.woocommerce-MyAccount-downloads-file:hover,
		.price_slider_amount .button:hover,
		.wishlist-title-with-form .button:hover,
		.sidebar-toggle:hover,
		.widget_layered_nav_filters li a:hover,
		.ywgc_apply_gift_card_button:hover,
		.product-item-wrapper .product-item-links .button:hover,
		.woocommerce-wishlist .product-item-wrapper .product-item-links a:hover {
			background: ' . get_theme_mod( 'button_secundary_hover_background_color' ) . ' !important;
			color: ' . get_theme_mod( 'button_secundary_hover_color' ) . ' !important;
			border-color: ' . get_theme_mod( 'button_secundary_hover_border_color' ) . ' !important;
		}
	}
';

/**
 * Primary color settings
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
$css_combined[] = '
	.woocommerce-product-gallery .flex-control-nav li .flex-active,
	.giftcard-button-mode button,
	.giftcard-button-mode button.selected_button,
	ul[data-attribute_name="attribute_ophangsysteem"] li div::before,
	body .accordion-coupon,
	body .accordion-giftcard,
	.searchform,
	.woocommerce .shop_table_responsive,
	.commentlist li:not(:last-child),
	.pewc-has-field-image.pewc-active-field,
	footer .footer-bottom-bar {border-color: ' . get_theme_mod( 'primary_color' ) . ';}

	.add_to_wishlist,
	body.et-db #et-boc .et-l .et_pb_module .add_to_wishlist,
	.yith-wcwl-wishlistaddedbrowse,
	.yith-wcwl-wishlistexistsbrowse,
	.product-item-wrapper .product-item-content .price,
	p.stars a:before,
	p.stars.selected a.active~a:before,
	p.stars a:before,
	.woocommerce-product-gallery .woocommerce-product-gallery__trigger::before,
	.summary .price,
	.summary .product_meta span.sku,
	.summary .product_meta a,
	.summary .variations td label,
	.summary .product_title,
	.product-usp-wrapper,
	.giftcard-button-mode button,
	.gift-cards-list .giftcard-button-mode button.selected_button,
	.ywgc-form-preview-amount,
	.accordion-item,
	ul[data-attribute_name="attribute_ophangsysteem"] li.selected,
	.related.products h2, .related.products h3, .recently-viewed h2,
	.add_to_wishlist,
	body.et-db #et-boc .et-l .et_pb_module .add_to_wishlist,
	.yith-wcwl-wishlistaddedbrowse,
	.yith-wcwl-wishlistexistsbrowse,
	.product-item-content .price,
	.product-item-content .product-category,
	.product-item-content h2,
	.product-item-content p,
	.woocommerce-sidebar-wrapper h3,
	.widget a,
	.cat-item .toggle,
	.wishlist-empty-page .icon, 
	.cart-empty-page .icon,
	.accordion-primary.show .accordion-toggle,
	.accordion-primary.show .accordion-content p,
	body #page-container #et-boc .product-slider-item a,
	body #page-container .product-slider-item a,
	body #page-container #et-boc .category-slider-item a,
	body #page-container .category-slider-item a,
	body #page-container #et-boc .product-block-item-container a,
	body #page-container .product-block-item-container a,
	.remove_from_cart_button,
	.product-sidebar-item-container i,
	.mini-cart-item-details .mini-cart-item-title,
	#yith-quick-view-close {color: ' . get_theme_mod( 'primary_color' ) . ';}

	.account-dashboard-item a:hover,
	.ywgc-form-preview-separator,
	body .accordion-primary,
	body #page-container .product-slider-item-small .product-slider-item-category {background-color: ' . get_theme_mod( 'primary_color' ) . ';}

	.owl-theme .owl-dots .owl-dot.active span,
	.nf-fu-progress-bar {background-color: ' . get_theme_mod( 'primary_color' ) . ' !important;}

	.product-item-content .price,
	.product-item-content .product-category,
	.button-mode li,
	.owl-nav button,
	.owl-nav button:hover {color: ' . get_theme_mod( 'primary_color' ) . ' !important;}

	.button-mode li,
	.button-mode li.selected {
		border-color:' . get_theme_mod( 'primary_color' ) . ' !important;
	}

	@media(hover:hover) and (pointer:fine){
		.woocommerce-product-gallery .flex-control-nav li img:hover,
		.button-mode li:not(.disabled):hover,
		.giftcard-button-mode button:not(.disabled):hover,
		.pewc-has-field-image:hover,
		.qty_button:hover {border-color: ' . get_theme_mod( 'primary_color' ) . ' !important;}

		p.stars a:hover~a:before,
		ul[data-attribute_name="attribute_ophangsysteem"] li:hover{color: ' . get_theme_mod( 'primary_color' ) . ';}

		.account-dashboard-item a:hover{background-color: ' . get_theme_mod( 'primary_color' ) . ';}

		.owl-theme .owl-dots .owl-dot:hover span {background-color: ' . get_theme_mod( 'primary_color' ) . ' !important;}
	}
';
/**
 * Secundary color settings
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
$css_combined[] = '
	body .product-usp-wrapper li::before,
	p.stars.selected a.active:before,
	p.stars.selected a:not(.active):before,
	p.stars.selected a.active:before {color: ' . get_theme_mod( 'secundary_color' ) . ';}

	@media(hover:hover) and (pointer:fine){
		p.stars:hover a:before,
		p.stars:hover a:before {color: ' . get_theme_mod( 'secundary_color' ) . ';}
	}
	.ui-slider .ui-slider-handle{background-color:' . get_theme_mod( 'secundary_color' ) . ';}

	.woocommerce-sidebar-wrapper .woocommerce-product-search {border-color: ' . get_theme_mod( 'secundary_color' ) . ';}
';
/**
 * Tertiary color settings
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
$css_combined[] = '
	ul[data-attribute_name="attribute_ophangsysteem"] li.selected div::before,
	.button-mode li.selected,
	.menu-hot-label::before,
	.menu-hot-label::after,
	.giftcard-button-mode button.selected_button {background-color:' . get_theme_mod( 'tertiary_color' ) . ' !important;}

	@media(hover:hover) and (pointer:fine){
		ul[data-attribute_name="attribute_ophangsysteem"] li:hover div::before,
		.button-mode li:not(.disabled):hover,
		.giftcard-button-mode button:not(.disabled):hover,
		.qty_button:hover {background-color:' . get_theme_mod( 'tertiary_color' ) . ' !important;}
	}
';
/**
 * Background color settings
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if ( $GLOBALS['theme_style_version'] == 'v2' || $GLOBALS['theme_style_version'] == 'v3' || $GLOBALS['theme_style_version'] == 'v4' || $GLOBALS['theme_style_version'] == 'v5' || $GLOBALS['theme_style_version'] == 'v6' ) :
	// Backgrounds
	$css_combined[] = '
	.theme-container.background-color {
		background-color: ' . get_theme_mod( 'background_light_color' ) . ';
	}';
	$css_combined[] = '
		.theme-button.theme-button-checkout,
		.place-order .theme-button{
			color: ' . get_theme_mod( 'primary_color' ) . ';
		}
	';
endif;
