<?php

/**
 * Content max width
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */

$css_combined[] = '
    .theme-row,
    .woocommerce-cart .woocommerce-notices-wrapper,
    .mobile-navigation-content-logo .mobile-navigation-content-logo-row {max-width:' . get_theme_mod( 'content_max_width' ) . '; width: 90% !important;margin: 0 auto;}
';
/**
 * Mobile background color
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
$css_combined[] = '
    @media (max-width:' . get_theme_mod( 'navigation_breakpoint' ) . '){
        body::after {
            content: "";
            position: fixed;
            top: 0;
            bottom: 0;
            left: 0;
            right: 0;
            background-color: #000000;
            z-index: 999;
            opacity: 0;
            pointer-events: none;
            transition: .2s;
            -webkit-transition: .2s;
            -moz-transition: .2s;
            -ms-transition: .2s;
            -o-transition: .2s;
        }
    }
';
/**
 * Fonts settings
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if ( get_theme_mod( 'google_fonts_toggle' ) == 1 ) :
	if ( esc_html( get_theme_mod( 'kls_headings_font' ) ) ) :
		$font_pieces    = explode( ':', esc_html( get_theme_mod( 'kls_headings_font' ) ) );
		$css_combined[] = 'h1, h2, h3, h4, h5, h6, body #et-boc .et-l h1, body #et-boc .et-l h2, body #et-boc .et-l h3, body #et-boc .et-l h4, body #et-boc .et-l h5, body #et-boc .et-l h6 { font-family: "' . $font_pieces[0] . '", Arial, sans-serif; }';
	endif;
	if ( esc_html( get_theme_mod( 'kls_body_font' ) ) ) :
		$font_pieces    = explode( ':', esc_html( get_theme_mod( 'kls_body_font' ) ) );
		$css_combined[] = 'body, button, input, select, textarea {font-family: "' . $font_pieces[0] . '", Arial, sans-serif;}';
	endif;

elseif ( get_theme_mod( 'custom_fonts_toggle' ) == 1 ) :
	if ( esc_html( get_theme_mod( 'kls_custom_fonts_heading' ) ) ) :
		$heading_get_fonts = preg_replace( '/^.*\/\s*/', '', get_theme_mod( 'kls_custom_fonts_heading' ) );
		$heading_font_name = substr( $heading_get_fonts, 0, strpos( $heading_get_fonts, '-' ) );

		$css_combined[] = 'h1, h2, h3, h4, h5, h6, body #et-boc .et-l h1, body #et-boc .et-l h2, body #et-boc .et-l h3, body #et-boc .et-l h4, body #et-boc .et-l h5, body #et-boc .et-l h6 { font-family: "' . $heading_font_name . '", Arial, sans-serif !important; }';
	endif;
	if ( esc_html( get_theme_mod( 'kls_custom_fonts_body' ) ) ) :
		$body_get_fonts = preg_replace( '/^.*\/\s*/', '', get_theme_mod( 'kls_custom_fonts_body' ) );
		$body_font_name = substr( $body_get_fonts, 0, strpos( $body_get_fonts, '-' ) );

		$css_combined[] = 'body, button, input, select, textarea {font-family: "' . $body_font_name . '", Arial, sans-serif !important;}';
	endif;
endif;

/**
 * Star rating settings
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
$css_combined[] = '
    .kls-rating {font-size:' . get_theme_mod( 'main_navigation_font_size' ) . ';}
    .kls-rating-number {color: ' . get_theme_mod( 'primary_color' ) . ';}
';
