<?php

/**
 * All general settings
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */

require_once __DIR__ . '/general_style.php';
/**
 * All color settings
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
require_once __DIR__ . '/color_style.php';

/**
 * All popup scripts
 *
 * @since 0.1.71
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if ( get_option( 'kls_popup_toggle' ) == 'on' ) :
	require_once __DIR__ . '/popup_style.php';
endif;

/**
 * All navigation settings
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if ( get_theme_mod( 'navigation_toggle' ) == 1 ) :
	require_once __DIR__ . '/navigation_style.php';
endif;
/**
 * All footer settings
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if ( get_theme_mod( 'footer_toggle' ) == '1' ) :
	require_once __DIR__ . '/footer_style.php';
endif;
/**
 * All WooCommerce settings
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if ( get_option( 'kls_webshop_toggle' ) == 'on' && class_exists( 'WooCommerce' ) ) {
	require_once __DIR__ . '/woocommerce_style.php';
}

/**
 * Action bar settings
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if ( get_option( 'kls_action_bar_toggle' ) == 'on' ) :
	require_once __DIR__ . '/action_bar_style.php';
endif;

/**
 * Button settings
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.39
 */
require_once __DIR__ . '/button_style.php';

/**
 * Form settings
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.79
 */
require_once __DIR__ . '/form_style.php';