<?php

/**
 * Woocommerce settings
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */

$css_combined[] = '.woocommerce.et-db #et-boc .et-l .et_pb_section .et_pb_row {max-width:' . get_theme_mod( 'content_max_width' ) . '; width: 90% !important;margin: 0 auto;}';
/**
 * Product toggles
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if ( get_theme_mod( 'product_categories_toggle' ) == 0 ) :
	$css_combined[] = '.product_meta .posted_in{display: none !important;}';
endif;
if ( get_theme_mod( 'product_tags_toggle' ) == 0 ) :
	$css_combined[] = '.product_meta .tagged_as{display: none !important;}';
endif;
if ( get_theme_mod( 'product_sku_toggle' ) == 0 && get_theme_mod( 'product_categories_toggle' ) == 0 && get_theme_mod( 'product_tags_toggle' ) == 0 ) :
	$css_combined[] = '.product-usp-wrapper{margin-top: 20px;padding-top: 20px;}body .summary .product_meta{padding: 0;}';
endif;
/**
 * My account
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if ( get_theme_mod( 'general_menu_my_account_toggle' ) == 1 ) :
	$css_combined[] = '
		.menu-my-account i{color:' . get_theme_mod( 'navigation_item_color' ) . ';transition:.2s;}
		header.header-fixed .menu-my-account i{color:' . get_theme_mod( 'navigation_fixed_item_color' ) . ';}
	';
endif;
/**
 * Wishlist
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if ( get_theme_mod( 'general_menu_wishlist_toggle' ) == 1 ) :
	$css_combined[] = '
		.menu-wishlist i{color:' . get_theme_mod( 'navigation_item_color' ) . ';transition:.2s;}
		header.header-fixed .menu-wishlist i{color:' . get_theme_mod( 'navigation_fixed_item_color' ) . ';}
	';
endif;
if ( get_theme_mod( 'wishlist_stock_status_toggle' ) == 0 ) :
	$css_combined[] = '.woocommerce .shop_table.wishlist_table .product-name {width: 50%;}
	@media (max-width: ' . $GLOBALS['kls_tablet_breakpoint'] . ') {.woocommerce .shop_table.wishlist_table .product-name {width: 30%;}}';
endif;
/**
 * Menu cart
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if ( get_theme_mod( 'general_menu_cart_toggle' ) == 1 ) :
	$css_combined[] = '
		.menu-cart i{color:' . get_theme_mod( 'navigation_item_color' ) . ';transition:.2s;}
		header.header-fixed .menu-cart i{color:' . get_theme_mod( 'navigation_fixed_item_color' ) . ';}
	';
endif;
/**
 * Checkout toggles
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if ( get_theme_mod( 'checkout_menu_toggle' ) == 1 ) :
	$css_combined[] = '.woocommerce-checkout:not(.woocommerce-order-received) .main-navigation-menu-wrapper,.woocommerce-checkout:not(.woocommerce-order-received) .top-nav-menu,.woocommerce-checkout:not(.woocommerce-order-received) .main-navigation-wrapper .searchform, .woocommerce-checkout:not(.woocommerce-order-received) .main-navigation-wrapper ul.menu,.woocommerce-checkout:not(.woocommerce-order-received) .navigation-wrapper-bottom, .woocommerce-checkout:not(.woocommerce-order-received) .nav-menu {display: none;}
	.woocommerce-checkout:not(.woocommerce-order-received) .mobile-navigation,.woocommerce-checkout:not(.woocommerce-order-received) .mobile-menu{display:none!important;}
	
	nav .logo {margin-right: 0 !important;}';
endif;
if ( get_theme_mod( 'checkout_footer_toggle' ) == 1 ) :
	$css_combined[] = '.woocommerce-checkout:not(.woocommerce-order-received) .footer-top-wrapper {display: none;}';
endif;
if ( $GLOBALS['theme_style_version'] == 'v2' && get_theme_mod( 'checkout_menu_toggle' ) == 1 ) :
	$css_combined[] = '.woocommerce-checkout:not(.woocommerce-order-received) .main-navigation-secundary-menu-wrapper{display: none !important;}
	.woocommerce-checkout:not(.woocommerce-order-received) nav .main-navigation-wrapper{padding-bottom: 20px !important; justify-content: center !important;}';
endif;
if ( $GLOBALS['theme_style_version'] == 'v2' && get_theme_mod( 'checkout_footer_toggle' ) == 1 ) :
	$css_combined[] = 'footer .footer-bottom-bar{border-top: 0 !important;}';
endif;
/**
 * Archive divi shortcode
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if ( get_theme_mod( 'archive_add_divi_shortcode_id' ) != 'none' ) :
	$css_combined[] = '.after-shop-wrapper:last-child, .archive .woocommerce-products-description:last-child{margin-bottom: 0 !important;}';
endif;
/**
 * Syncsilo compatibility
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if ( get_option( 'kls_syncsilo_compatibility_toggle' ) == 'on' ) {
	$css_combined[] = '
	.is_configurable>#page-container>#yith-quick-view-modal>.product>div:not(.kls_is_configurable) .quantity{
		display: inline-flex !important;
	} 

	.is_configurable>#page-container>#yith-quick-view-modal>.product>div:not(.kls_is_configurable) .single_add_to_cart_button{
		display: inline-block !important;
	}

	.is_configurable>#page-container>div.kls_is_configurable .summary form.cart{
		display: inline-flex;
	}

	.is_configurable>#page-container>div.kls_is_configurable .summary .ww-configurator{
		float: left;
	}

	#yith-quick-view-modal .single-product>.product>.product.kls_is_configurable .single_add_to_cart_button:not(.button) {
		display: inline-block !important;
		float: left;
	}
	
	#yith-quick-view-modal .single-product>.product>.product.kls_is_configurable .single_add_to_cart_button.button,
	#yith-quick-view-modal .single-product>.product>.product.kls_is_configurable .quantity {
		display: none;
	}
	
	#yith-quick-view-modal .single-product>.product>.product.kls_is_configurable .summary form.cart{
		display: inline-flex;
	}
	';
}

/**
 * block layout shortcode
 *
 * @since 0.1.04
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
$css_combined[] = '
	.category-block-layout-item-content-container{background-color:' . get_theme_mod( 'background_light_color' ) . ' !important;}

	.category-block-layout-content{color:' . get_theme_mod( 'primary_color' ) . ' !important;}

	.category-block-layout-content i {background-color:' . get_theme_mod( 'primary_color' ) . ' !important; color: #ffffff !important;}
	@media (hover:hover) and (pointer:fine){
		.category-block-layout-item:hover .category-block-layout-item-content-container{background-color:' . get_theme_mod( 'primary_color' ) . ' !important;}
		.category-block-layout-item:hover .category-block-layout-content{color:' . get_theme_mod( 'background_light_color' ) . ' !important;}
		.category-block-layout-item:hover .category-block-layout-content i {background-color: #ffffff !important; color: ' . get_theme_mod( 'primary_color' ) . ' !important;}
	}
';


/**
 * Shop v5 slider color reversal
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.51
 */
if ( $GLOBALS['theme_style_version'] == 'v5' || $GLOBALS['theme_style_version'] == 'v6' ) :
	$css_combined[] = '
	.owl-carousel:not(.owl-carousel-product-page) .product-slider-item:not(.product-slider-item-small) .product-slider-item-content-container{color: ' . get_theme_mod( 'secundary_color' ) . ' !important;}
	body .owl-carousel:not(.owl-carousel-product-page) .product-slider-item:not(.product-slider-item-small) .product-slider-item-content-container{background-color:' . get_theme_mod( 'primary_color' ) . ' !important}
	';
endif;

/**
 * Read more cs
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.53
 */
if ( get_theme_mod( 'product_first_tab_open_toggle' ) == 1 && get_theme_mod( 'product_description_read_more_toggle' ) == 1 ) {
	$css_combined[] = '
	.read-more-content{overflow: hidden;transition: .3s;position: relative;}
	.read-more-content.read-more-content-hidden{height: 50px;}

	.accordion-content .read-more-button{display:block; text-align:center;cursor: pointer !important;}

	.accordion-content .read-more-content-hidden::after{
		content:"";
		width: 100%;
		height: 50%;
		position: absolute;
		left: 0;
		bottom: 0;
		background: linear-gradient(0deg, rgba(255,255,255,1) 0%, rgba(0,157,227,0) 100%);
	}
	';
}

/**
 * Product tabs mode
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.57
 */
if ( 'tabs' == get_theme_mod( 'kls_product_tabs_mode' ) || 'tabs-small' == get_theme_mod( 'kls_product_tabs_mode' ) ) {
	$css_combined[] = '
		.tabs-item{display: none}
		.tabs-item.active{display:block}

		.background-color .tabs-item {background-color: #ffffff;}

		@media (max-width:' . $GLOBALS['kls_tablet_breakpoint'] . ') {
			.tabs-list, .tabs-toggle {display: block !important;}
			.tabs-toggle, .tabs-item {border-radius: 5px;}
			.tabs-toggle {text-align: left !important;}
			.tabs-list {margin-bottom: 10px;}
			.tabs-item {padding:20px;}
		}
	';
	if ( 'tabs' == get_theme_mod( 'kls_product_tabs_mode' ) ) {
		$css_combined[] = '
			.tabs-wrapper {padding-top:20px}
			.tabs-content .woocommerce-product-attributes {
				margin-top: 20px !important;
			}

			.tabs-toggle {
				font-size: 20px !important;
				padding: 20px;
				background: #ffffff;
				position: relative;
				display: inline-block;
				cursor: pointer;
				flex: 1;
				text-align: center;
				line-height: 1.7em;
				font-weight: bold;
				border-radius: 5px 5px 0 0;
				transition: .2s;
				border-radius: 5px;
				-webkit-border-radius: 5px;
				-moz-border-radius: 5px;
				-ms-border-radius: 5px;
				-o-border-radius: 5px;
			}

			.tabs-toggle::after {
				content: "";
				position: absolute;
				bottom: -2px;
				left: calc(50% - 10px);
				width: 20px;
				height: 20px;
				background-color: transparent;
				z-index: 1;
				-webkit-transform-origin: center center;
				transform-origin: center center;
				-webkit-transform: rotate(45deg);
				transform: rotate(45deg);
				border-radius: 3px;
				opacity: 0;
				transition: .2s;
				-webkit-transition: .2s;
				-moz-transition: .2s;
				-ms-transition: .2s;
				-o-transition: .2s;
			}

			.tabs-toggle.active::after {
				background-color: ' . get_theme_mod( 'primary_color' ) . ';
			}

			.tabs-list {
				margin-bottom: 20px !important;
				display: flex;
			}

			.tabs-toggle.active {background-color: ' . get_theme_mod( 'primary_color' ) . ' !important;}

			.tabs-item {
				padding: 30px 20px;
				border-radius: 0 0 5px 5px;
			}

			.background-color .tabs-item {background-color: #ffffff;}

			.tabs-item.summary {
				background-color: transparent;
			}

			@media(hover:hover) and (pointer:fine){
				.tabs-toggle:hover {background-color: ' . get_theme_mod( 'primary_color' ) . ' !important;}
			}

			@media (min-width: 980px) {
				.tabs-toggle {
					border-radius: 0;
					-webkit-border-radius: 0;
					-moz-border-radius: 0;
					-ms-border-radius: 0;
					-o-border-radius: 0;
				}

				.tabs-toggle:first-child {
					border-radius: 5px 0 0 5px !important;
					-webkit-border-radius: 5px 0 0 5px !important;
					-moz-border-radius: 5px 0 0 5px !important;
					-ms-border-radius: 5px 0 0 5px !important;
					-o-border-radius: 5px 0 0 5px !important;
				}

				.tabs-toggle:last-child {
					border-radius: 0 5px 5px 0 !important;
					-webkit-border-radius: 0 5px 5px 0 !important;
					-moz-border-radius: 0 5px 5px 0 !important;
					-ms-border-radius: 0 5px 5px 0 !important;
					-o-border-radius: 0 5px 5px 0 !important;
				}

				.tabs-toggle.active::after {
					opacity: 1;
				}
			}
		';
	} elseif ( 'tabs-small' == get_theme_mod( 'kls_product_tabs_mode' ) ) {
		$css_combined[] = '
			.tabs-list {display: inline-block; font-size: 0;}
			.tabs-toggle {
				position: relative;
				display: inline-block;
				cursor: pointer;
				flex: 1;
				text-align: center;
				padding: 10px 20px;
				font-size: 16px;
				line-height: 1.7em;
				font-weight: bold;
				border-radius: 5px 5px 0 0;
				transition: .2s;
				border-bottom: 2px solid #ffffff;
			}

			.tabs-item {
				padding: 30px 20px;
				border-radius: 0 0 5px 5px;
			}

			.background-color .tabs-item {background-color: #ffffff;}
			
			.tabs-toggle.active {border-color: ' . get_theme_mod( 'primary_color' ) . ' !important;}

			@media(hover:hover) and (pointer:fine){
				.tabs-toggle:hover {border-color: ' . get_theme_mod( 'primary_color' ) . ' !important;}
			}
		';
	}
} else if( 'simple' == get_theme_mod('kls_product_tabs_mode') ) {
	$css_combined[] = '
		.woocommerce-tabs {
			margin-bottom: 50px;
		}

		.woocommerce-Tabs-panel {
			margin-bottom: 25px;
		}
	';
} else {
	$css_combined[] = '
		.product-accordion {
			margin-top: 20px;
		}

		.accordion-wrapper {
			padding-top: 20px;
		}

		.accordion-item {
			padding: 10px 20px;
			-webkit-border-radius: 5px;
			-moz-border-radius: 5px;
			border-radius: 5px;
		}

		.accordion-item:not(:last-child) {
			margin-bottom: 10px;
		}

		.accordion-toggle {
			cursor: pointer;
			font-size: 14px;
			font-weight: bold;
			line-height: 1.7em;
			transition: .2s;
			-webkit-transition: .2s;
			-moz-transition: .2s;
			-ms-transition: .2s;
			-o-transition: .2s;
		}

		.accordion-toggle p::after {
			font-family: "Font Awesome 5 Free";
			font-weight: bold;
			float: right;
			transition: .2s;
			-webkit-transition: .2s;
			-moz-transition: .2s;
			-ms-transition: .2s;
			-o-transition: .2s;
		}

		.accordion-content {
			padding-top: 10px;
		}

		.accordion-content.show {
			padding-bottom: 10px;
		}
	';
}

/**
 * Product theme banner styling
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.58
 */
if ( get_theme_mod( 'kls_product_banner_toggle' ) == 1 ) {
	$css_combined[] = '
		.theme-product-banner {
			padding: ' . get_theme_mod( 'kls_product_banner_padding', '50px 0' ) . ';
			background: ' . get_theme_mod( 'kls_product_banner_background_color', get_theme_mod( 'background_light_color' ) ) . ';
		}

		.theme-product-banner h1,
		.theme-product-banner p,
		.theme-product-banner nav,
		.theme-product-banner a {
			color: ' . get_theme_mod( 'kls_product_banner_color' ) . ' !important;
		}

		.product .theme-container:first-child {
			padding-top: 50px;
		}
	';

	if ( wp_attachment_is_image( get_theme_mod( 'kls_product_banner_background_image' ) ) ) {
		$css_combined[] = '
			.theme-product-banner {
				background-image: url(' . esc_url_raw( wp_get_attachment_url( get_theme_mod( 'kls_product_banner_background_image', '' ) ) ) . ');
				background-size: cover;
				background-position: center;
				background-repeat: no-repeat;
				background-blend-mode: overlay;
			}
		';
	} else {
		$css_combined[] = '
			.theme-product-banner {
				overflow: hidden;
				position: relative;
			}

			.theme-product-banner video{
				position: absolute;
				top: 50%;
				left: 0;
				width: 100%;
				transform: translatey(-50%);
				z-index: -1;
				height: auto;
			}
		';
	}
}

/**
 * Archive theme banner styling
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.58
 */
if ( get_theme_mod( 'kls_archive_banner_toggle' ) == 1 ) {
	$css_combined[] = '
		.theme-archive-banner {
			padding: ' . get_theme_mod( 'kls_archive_banner_padding', '50px 0' ) . ';
			background: ' . get_theme_mod( 'kls_archive_banner_background_color', get_theme_mod( 'background_light_color' ) ) . ';
		}

		.theme-archive-banner h1,
		.theme-archive-banner p,
		.theme-archive-banner nav,
		.theme-archive-banner a {
			color: ' . get_theme_mod( 'kls_archive_banner_color' ) . ' !important;
		}

		.archive .theme-container:nth-child(2) {
			padding-top: 50px;
		}

		.theme-archive-banner-video {
			overflow: hidden;
			position: relative;
		}

		.theme-archive-banner-video video{
			position: absolute;
			top: 50%;
			left: 0;
			width: 100%;
			transform: translatey(-50%);
			z-index: -1;
			height: auto;
		}
	';
}

/**
 * Checkout flow V4 styling
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.62
 */
if ( 'v4' == get_theme_mod( 'kls_checkout_flow_version', 'v1' ) ) {
	$css_combined[] = '
	.woocommerce-checkout-breadcrumb .breadcrumb li.current a,
	.woocommerce-checkout-breadcrumb .breadcrumb li.current a::after{
		background: ' . get_theme_mod( 'primary_color' ) . ';
		color: #ffffff !important;
	}

	.wc_payment_methods li:has(input:checked) {
		border-color: ' . get_theme_mod( 'primary_color' ) . ';
	}
	
	.woocommerce-cart-shipping-item .woocommerce-shipping-methods li input:checked ~ label,
	.woocommerce-cart-shipping-item .woocommerce-shipping-methods li:only-child label {
		border-color: ' . get_theme_mod( 'primary_color' ) . ';
	}

	.cart-collaterals,
	.checkout-totals {
		color: ' . get_theme_mod( 'body_text_color' ) . ';
	}

	@media (hover:hover) and (pointer:fine){
		.wc_payment_methods li:hover,
		.woocommerce-cart-shipping-item .woocommerce-shipping-methods li label:hover{
			border-color: ' . get_theme_mod( 'primary_color' ) . ';
		}
	}
	';
} else {
	$css_combined[] = '
	.cart-collaterals,
	.checkout-totals{
		background-color: ' . get_theme_mod( 'primary_color' ) . ';
	}
	
	@media(hover:hover) and (pointer:fine){
		.place-order .theme-button:hover,
		.theme-button.theme-button-checkout:hover{
			background-color: ' . get_theme_mod( 'primary_color' ) . ';
		}
	}
	';
}

/**
 * Mini cart toggle variations
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.64
 */
if ( 1 == get_theme_mod( 'kls_mini_cart_toggle_variations', 0 ) ) {
	$css_combined[] = '
	.mini-cart-item-details .variation {
		display: block;
	}
	';
} else {
	$css_combined[] = '
	.mini-cart-item-details .variation {
		display: none;
	}
	';
}
