<?php

/**
 * Actionbar mobile position
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */

$js_combined[] = '
var waitForFinalEventActionBar = (function () {
    var timers = {};
    return function (callback, ms, uniqueId) {
        if (!uniqueId) {
            uniqueId = "Dont call this twice without a uniqueId"
        }
        if (timers[uniqueId]) {
            clearTimeout(timers[uniqueId])
        }
        timers[uniqueId] = setTimeout(callback, ms)
    }
})();
';

$js_combined[] = '
    function actionbarPosition(){
        var actionBarHeight = $("#klsactionbar").height();
        var closeButtonHeight = $(".close-button-container").height();
        if($(window).width() < "' . str_replace( 'px', '', get_theme_mod( 'navigation_breakpoint' ) ) . '" ){
        ';
if ( get_theme_mod( 'mobile_navigation_position' ) == 'bottom' ) :
	$js_combined[] = '$("#klsactionbar .close-button-container").css({"bottom": "auto", "top": (actionBarHeight - closeButtonHeight) / 2});';
else :
	$js_combined[] = '$("#klsactionbar .close-button-container").css({"top": "auto", "bottom": (actionBarHeight - closeButtonHeight) / 2});';
endif;
$js_combined[] = '

        } else {
            $("#klsactionbar .close-button-container").css({"top": "auto", "bottom": (actionBarHeight - closeButtonHeight) / 2});
        }
    }

    actionbarPosition();
    
    $(window).resize(function () {
        waitForFinalEventActionBar(function(){
            actionbarPosition();
        });
    });
';
