<?php

/**
 * Standard mobile navigation scripts
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */

// $js_combined[] = '
// var waitForFinalEventMobile = (function () {
// var timers = {};
// return function (callback, ms, uniqueId) {
// if (!uniqueId) {
// uniqueId = "Dont call this twice without a uniqueId"
// }
// if (timers[uniqueId]) {
// clearTimeout(timers[uniqueId])
// }
// timers[uniqueId] = setTimeout(callback, ms)
// }
// })();
// ';

$js_combined[] = '
    $(".mobile-menu-toggle").on("click", function(){$(".mobile-menu").toggleClass("visible");$(this).toggleClass("visible");$("body").toggleClass("mobile-menu-visible")});

    $(".mobile-menu-close").on("click", function(){
        $(".mobile-menu").removeClass("visible");
        $(".mobile-menu-toggle").removeClass("visible");
        $("body").removeClass("mobile-menu-visible")
    });

    $(document).mouseup(function(e){
        var container = $(".mobile-menu, .mobile-navigation, .mobile-menu-toggle");
        if (!container.is(e.target) && container.has(e.target).length === 0){
            container.removeClass("visible");
            $("body").removeClass("mobile-menu-visible");
        }
    });

    $(".mobile-menu-items .menu-item:not(.menu-item-has-children)").has("a[href*=\\#]").on("click", function(){
        $(".mobile-menu").removeClass("visible");
        $(".mobile-menu-toggle").removeClass("visible");
        $("body").removeClass("mobile-menu-visible");
    });
';

/**
 * Specific mobile navigation scripts
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if ( $GLOBALS['kls_mobile_navigation_version'] == 'bottom_bar-v1' ) :
	$js_combined[] = '';
elseif ( $GLOBALS['kls_mobile_navigation_version'] == 'default-v1' || $GLOBALS['kls_mobile_navigation_version'] == 'default-v1-fullwidth' ) :
	$js_combined[] = '';
elseif ( $GLOBALS['kls_mobile_navigation_version'] == 'bottom_bar_shop-v2' ) :
	$js_combined[] = '';
endif;
