<?php

/**
 * Wishlist settings
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
$js_combined[] = '
if ( $( "header .menu-wishlist .menu-wishlist-count" ).length ) {
		$( document.body ).on( "added_to_wishlist removed_from_wishlist added_to_cart", function ( e ) {
			var $obj = $( "header .menu-wishlist .menu-wishlist-count" );
			if ( $obj.text() ) {
				$.ajax( {
					type: "POST",
					dataType: "json",
					url: "' . admin_url( 'admin-ajax.php' ) . '" ,
					data: {
						action: "kls_refresh_wishlist_count",
					},
					success: function ( response ) {
						if ( response || 0 === response ) {
							$obj.addClass( "count-updating" ).text( Number( response ) );
							setTimeout( function () {
								$obj.removeClass( "count-updating" );
							}, 1000 );
						}
					}
				} );
			}
		} );
	}
';

/**
 * Product archive filter toggle
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
$js_combined[] = '
	$(".sidebar-toggle, .sidebar-close").on("click", function(){
		$(".sidebar").toggleClass("active");
		$("body").toggleClass("sidebar-active");
	});

	$(document).mouseup(function(e){
		var container = $(".sidebar, .sidebar-toggle, .sidebar-close");
		if (!container.is(e.target) && container.has(e.target).length === 0){
			container.removeClass("active");
			$("body").removeClass("sidebar-active");
		}
	});
';

if ( get_theme_mod( 'archive_filter_read_more_toggle' ) == 1 ) :
	// Product archive read more filters.
	$js_combined[] = '
	var filterListItemAmount = $(".woocommerce-widget-layered-nav-list li").length;
	if(filterListItemAmount > ' . get_theme_mod( 'archive_filter_read_more_amount' ) . '){
		$(".woocommerce-widget-layered-nav-list").append("<div class=button-link>' . kls_translate_theme_mod( 'archive_filter_read_more_text', 'Archief laad meer knop', 'nl' ) . ' &nbsp;</div>");
		var list = $(".woocommerce-widget-layered-nav-list li");
		var numToShow = ' . get_theme_mod( 'archive_filter_read_more_amount' ) . ';
		var button = $(".woocommerce-widget-layered-nav-list .button-link");
		var numInList = list.length;
		list.hide();
		if (numInList > numToShow) {
			button.show();
		}
		list.slice(0, numToShow).show();

		button.click(function(){
			var showing = list.filter(":visible").length;
			list.slice(showing - 1, showing + numToShow).fadeIn();
			var nowShowing = list.filter(":visible").length;
			if (nowShowing >= numInList) {
				button.hide();
			}
		});
	}';
	// Product archive read more categories.
	$js_combined[] = '
	var categoryListItemAmount = $(".product-categories>li").length;
	if(categoryListItemAmount > ' . get_theme_mod( 'archive_filter_read_more_amount' ) . '){
		$(".product-categories").append("<div class=button-link>' . kls_translate_theme_mod( 'archive_filter_read_more_text', 'Archief laad meer knop', 'nl' ) . ' &nbsp;</div>");
		var categorylist = $(".product-categories>li");
		var categorynumToShow = ' . get_theme_mod( 'archive_filter_read_more_amount' ) . ';
		var categorybutton = $(".product-categories .button-link");
		var categorynumInList = categorylist.length;
		categorylist.hide();
		if (categorynumInList > categorynumToShow) {
			categorybutton.show();
		}
		categorylist.slice(0, categorynumToShow).show();

		categorybutton.click(function(){
			var categoryshowing = categorylist.filter(":visible").length;
			categorylist.slice(categoryshowing - 1, categoryshowing + categorynumToShow).fadeIn();
			var categorynowShowing = categorylist.filter(":visible").length;
			if (categorynowShowing >= categorynumInList) {
				categorybutton.hide();
			}
		});
	}';
endif;

if ( get_theme_mod( 'product_variation_read_more_toggle' ) == 1 && get_theme_mod( 'product_variation_selection_mode_select' ) == 'label' || get_theme_mod( 'product_variation_read_more_toggle' ) == 1 && get_theme_mod( 'product_variation_selection_mode_select' ) == 'accordion' ) :
	// Product page read more.
	$js_combined[] = '
	var variableItemWrapper = $(".variable-items-wrapper").length;

	$(".variable-items-wrapper").each(function(){
		var filterListItemAmount = $(this).find("li").length;
		if(filterListItemAmount > ' . get_theme_mod( 'product_variation_read_more_amount' ) . '){
			$(this).append("<div class=button-link>' . kls_translate_theme_mod( 'product_variation_read_more_text', 'Product variatie laad meer knop', 'nl' ) . ' &nbsp;</div>");

			var list = $(this).find("li");
			var numToShow = ' . get_theme_mod( 'product_variation_read_more_amount' ) . ';
			var button = $(this).find(".button-link");
			var numInList = list.length;

			list.hide();

			if (numInList > numToShow) {
				button.show();
			}
			
			list.slice(0, numToShow).show();

			button.click(function(){
				var showing = list.filter(":visible").length;
				list.slice(showing - 1, showing + numToShow).fadeIn();
				var nowShowing = list.filter(":visible").length;
				if (nowShowing >= numInList) {
					button.hide();
				}
			});
		}
	});';
endif;

$js_combined[] = '
	$( ".variations_form" ).on( "woocommerce_variation_select_change", function (event) {
		if ( !$(event.target).is(".reset_variations") && $(".reset_variations").css( "visibility" ) == "hidden" ){
			$(".reset_variations").addClass("visible");
		}
	});
';

// Read more.
if ( get_theme_mod( 'product_first_tab_open_toggle' ) == 1 && get_theme_mod( 'product_description_read_more_toggle' ) == 1 ) {
	$js_combined[] = '
		var readMoreHeight = $(".read-more-content").height();
		if(readMoreHeight >= 50) {
			$(".read-more-content").addClass("read-more-content-hidden");

			$(".read-more-button").on("click", function() {
				var readMoreParent= $(this).parent().find(".read-more-content");

				if($(this).text() == theme_object.read_more ) {
					readMoreParent.toggleClass("read-more-content-hidden").css("height", readMoreHeight);
					$(this).text( theme_object.read_less );
				} else {
					readMoreParent.toggleClass("read-more-content-hidden").css("height", "50px");
					$(this).text( theme_object.read_more );
				}
			});
		} else {
			$(".read-more-button").hide();
		}
	';
}

/**
 * Product tabs mode
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.57
 */
if ( 'tabs' == get_theme_mod( 'kls_product_tabs_mode' ) || 'tabs-small' == get_theme_mod( 'kls_product_tabs_mode' ) ) {
	$js_combined[] = '
		$(".tabs-toggle").on("click", function(e) {
			e.preventDefault();

			$(".tabs-toggle").removeClass("active");
			$(this).addClass("active");

			var tab_id = this.getAttribute("data-tab-id");

			$(".tabs-item").removeClass("active");
			$(".tabs-item[data-tab-id="+tab_id+"]").addClass("active");
		});

		$(".theme-order-button").on("click", function() {
			$(".tabs-toggle").removeClass("active");
			$(".tabs-toggle[data-tab-id=summary]").addClass("active");

			$(".tabs-item").removeClass("active");
			$(".tabs-item[data-tab-id=summary]").addClass("active");
		});
	';
} else {
	$js_combined[] = '
		if( !$("body").hasClass("woocommerce-checkout") && !$("body").hasClass("woocommerce-cart") ) {
			$(".accordion-toggle").click(function(e) {
				e.preventDefault();
			
				var $this = $(this);
			
				if ($this.next().hasClass("show")) {
					$this.next().removeClass("show");
					$this.next().slideUp(350);
					$this.removeClass("show");
					$this.next().parent().removeClass("show");
				} else {
					$this.parent().parent().find("div .accordion-content").removeClass("show");
					$this.parent().parent().find("div .accordion-toggle").removeClass("show");
					$this.parent().parent().find(".accordion-item").removeClass("show");
					$this.parent().parent().find("div .accordion-content").slideUp(350);
					$this.parent().toggleClass("show");
					$this.next().toggleClass("show");
					$this.toggleClass("show");
					$this.next().slideToggle(350);
				}
			});
		}

		$(".theme-order-button").on("click", function() {
			if ( !$(".accordion-item.summary").hasClass("show") ) {
				$(".accordion-item, .accordion-toggle, .accordion-content").removeClass("show");
				$(".accordion-item .accordion-content").slideUp(350);

				$(".accordion-item.summary, .accordion-item.summary .accordion-toggle, .accordion-item.summary .accordion-content").addClass("show");
				$(".accordion-item.summary .accordion-content").slideToggle(350);
			}
		});
	';
}

/**
 * Mini cart
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.62
 */
if ( 'v2' == $GLOBALS['kls_mini_cart_style_version'] ) {
	$js_combined[] = '
		$(".menu-cart, .mini-cart-close").on("click", function(){
			$("body").toggleClass("mini-cart-active");
			$(".menu-cart-popup").toggleClass("hidden");
		});
	';
}

$js_combined[] = '
	$(document).mouseup(function(e){
		var container = $(".menu-cart, .mini-cart-close, .menu-cart-popup");
		if (!container.is(e.target) && container.has(e.target).length === 0){
			container.addClass("hidden");
			$("body").removeClass("mini-cart-active");
		}
	});
';
