<?php

/**
 * Create the mini cart
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.62
 */
function kls_mini_cart() {
	if ( $GLOBALS['kls_mini_cart_style_version'] == 'v1' ) :
		?>
		<div class="menu-cart-popup hidden">
			<div class="menu-cart-total-wrapper">
				<div>
					<span class="cart-count">
					<?php
					$items = sizeof( WC()->cart->get_cart() );
					echo $items . '</span> ';
					echo sprintf( esc_html( _n( 'Item', 'Items', $items, 'klasse-theme' ) ), $items );
					?>
				</div>
				<a class="button-link" href="<?php echo wc_get_cart_url(); ?>"><?php echo __( 'View cart', 'klasse-theme' ); ?></a>
			</div>
			<div class="menu-cart-items">
				<div class="widget_shopping_cart_content">
					<?php
					echo woocommerce_mini_cart();
					?>
				</div>
			</div>
		</div>
		  <?php
	elseif ( $GLOBALS['kls_mini_cart_style_version'] == 'v2' ) :
		?>
		<div class="menu-cart-popup hidden <?php echo WC()->cart->is_empty() ? 'empty' : ''; ?> ">
			<div class="menu-cart-popup-container">
				<div class="menu-cart-popup-text">
					<h2><?php _e( 'Cart', 'klasse-theme' ); ?></h2>
					<div class="menu-cart-popup-actions">
						<?php if ( ! WC()->cart->is_empty() ) : ?>
							<a href="<?php echo wc_get_checkout_url(); ?>" class="theme-button theme-button-secundary"><?php esc_html_e( 'Order now', 'klasse-theme' ); ?></a>
						<?php endif; ?>
						<div class="mini-cart-close"><i class="fas fa-times"></i></div>
					</div>
				</div>
				<div class="menu-cart-items">
					<div class="widget_shopping_cart_content">
						<?php
						echo woocommerce_mini_cart();
						?>
					</div>
				</div>
			</div>
		</div>
		<?php
	endif;
}
add_action( 'kls_mini_cart_' . $GLOBALS['kls_mini_cart_style_version'], 'kls_mini_cart' );

function custom_product_variation_title( $should_include_attributes, $product ) {
	$should_include_attributes = false;
	return $should_include_attributes;
}
add_filter( 'woocommerce_product_variation_title_include_attributes', 'custom_product_variation_title', 10, 2 );

function woocommerce_clear_cart_url() {
	if ( isset( $_GET['clear-cart'] ) ) {
		global $woocommerce;
		$woocommerce->cart->empty_cart();
	}
}
add_action( 'init', 'woocommerce_clear_cart_url' );

/**
 * Open the cart popup after item is added to cart
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.63
 */
function single_added_to_cart_event() {
	if ( get_theme_mod( 'kls_mini_cart_open_after_add_to_cart' ) == 1 ) :
		if ( isset( $_POST['add-to-cart'] ) ) :
			$id_to_check   = isset( $_POST['variation_id'] ) ? esc_attr( $_POST['variation_id'] ) : esc_attr( $_POST['add-to-cart'] );
			$found_in_cart = false;

			// Check cart items to be sure that the product has been added to cart (and get product data).
			foreach ( WC()->cart->get_cart() as $item ) {
				$product = $item['data'];
				if ( $product->get_id() == $id_to_check ) {
					$found_in_cart = true;
					break;
				}
			}

			if ( $found_in_cart ) :
				?>
				<script>
				jQuery(function($){
					jQuery('.menu-cart-popup').removeClass('hidden');
					jQuery('body').addClass('mini-cart-active');
				});
				</script>
				<?php
			endif;
		endif;
	endif;
}
add_action( 'wp_footer', 'single_added_to_cart_event' );
