<?php // phpcs:ignore
/**
 * Product configurator class
 *
 * @category   Klasse_Theme
 * @package    KT
 * @subpackage KT/includes/woocommerce
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.1.78
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
	exit;
}

if (!class_exists('KT_Product_Configurator')) {
	/**
	 * Product configurator class
	 *
	 * @category    Klasse_Theme
	 * @package     KT
	 * @subpackage  KT/includes/woocommerce
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.1.78
	 */
	class KT_Product_Configurator
	{
		/**
		 * Construct the product configurator.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.1.78
		 */
		public function __construct()
		{
			add_action('woocommerce_add_to_cart', array($this, 'fixProductAddonsDiviFatalError'), 10, 6);
		}

		/**
		 * This fixes compatibility issues between the WooCommerce Product Add-ons plugin and the Divi builder.
		 * 
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 * 
		 * @since 0.1.78
		 * 
		 * Todo, this has to be tested with products that use Divi and have background patterns or masks.
		 */
		public function fixProductAddonsDiviFatalError($cart_item_key, $product_id, $quantity, $variation_id, $variation, $cart_item_data)
		{
			$has_product_extras = isset($cart_item_data['product_extras']['original_price']);
			$pattern_key = 'et_pb_get_pattern_style_options';
			$mask_key = 'et_pb_get_mask_style_options';

			if ($has_product_extras && function_exists('et_core_cache_set')) {
				if (!et_core_cache_has($pattern_key)) {
					et_core_cache_set($pattern_key, '');
				}

				if (!et_core_cache_has($mask_key)) {
					et_core_cache_set($mask_key, '');
				}
			}
		}
	}

	new KT_Product_Configurator();
}