<?php

/**
 * Set the Woocommerce layout
 *
 * @since 0.0.12
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */

add_action( 'wp', 'kls_woocommerce_layout' );
function kls_woocommerce_layout() {
	 // Remove add to cart button for product loop
	remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart' );
	add_action( 'kls_product_item_links', 'woocommerce_template_loop_add_to_cart' );
	// Product archive
	add_filter( 'woocommerce_subcategory_count_html', '__return_false' );
	remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );
	remove_action( 'woocommerce_archive_description', 'woocommerce_taxonomy_archive_description', 10 );
	remove_action( 'woocommerce_archive_description', 'woocommerce_product_archive_description', 10 );
	remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );
	add_action( 'kls_before_shop_loop', 'woocommerce_catalog_ordering', 30 );
	// Standard breadcrumb
	remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0 );
	// Remove standard woocommerce before content
	remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10 );
	remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10 );
}

// Quick view buttons
if ( class_exists( 'YITH_WCQV' ) && class_exists( 'YITH_WCQV_Frontend' ) ) {
	remove_action( 'init', array( YITH_WCQV_Frontend::get_instance(), 'add_button' ) );
	if ( get_theme_mod( 'archive_quickview_toggle' ) == 1 ) {
		add_action( 'woocommerce_before_shop_loop_item_title', array( YITH_WCQV_Frontend::get_instance(), 'yith_add_quick_view_button' ), 15 );
	}
}

add_filter( 'woocommerce_cross_sells_columns', 'kls_change_cross_sells_columns' );
function kls_change_cross_sells_columns( $columns ) {
	return 3;
}

add_filter( 'woocommerce_cross_sells_total', 'kls_change_cross_sells_product_no' );

function kls_change_cross_sells_product_no( $columns ) {
	return 3;
}

/**
 * Move the wishlist item
 *
 * @since 0.0.12
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if ( defined( 'YITH_WCWL' ) && ! function_exists( 'kls_move_wishlist_button' ) ) {
	function kls_move_wishlist_button() {
		echo do_shortcode( '[yith_wcwl_add_to_wishlist]' );
	}
	add_action( 'woocommerce_after_add_to_cart_button', 'kls_move_wishlist_button', 45 );
	add_action( 'woocommerce_shop_loop_item_title', 'kls_move_wishlist_button', 45 );
}
