<?php

/**
 * Add the fix to the head.
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.15
 */
function kls_set_body_whitespace() {
	$header_version            = $GLOBALS['kls_main_navigation_version'];
	$mobile_navigation_version = $GLOBALS['kls_mobile_navigation_version'];
	$calculated                = ( get_the_header_height( $header_version ) ? get_the_header_height( $header_version ) : 0 );
	$calculated_mobile         = ( get_the_mobile_navigation_height( $mobile_navigation_version ) ? get_the_mobile_navigation_height( $mobile_navigation_version ) : 0 );

	$style = '';

	// Fixed menu with transparent background color
	// [Dev] Todo, min-width is set op 768px but has to be set at 769px because it interferes with the top margin at 768px.

	// If the breakpoint of the menu is smaller than the tablet breakpoint
	$breakpoint        = preg_replace( '/\D+/', '', get_theme_mod( 'navigation_breakpoint' ) ) . 'px';
	$tablet_breakpoint = $GLOBALS['kls_tablet_breakpoint'];
	$phone_breakpoint  = $GLOBALS['kls_phone_breakpoint'];
	if ( $breakpoint < $tablet_breakpoint == true || $breakpoint > $tablet_breakpoint == true ) :
		$tablet_breakpoint = $breakpoint;
	endif;

	if ( get_theme_mod( 'fixed_navigation_toggle' ) == 1 ) :
		if ( strpos( get_theme_mod( 'main_navigation_background_color' ), 'rgba' ) !== false ) :
			$style .= '
            <style>
                @media (min-width:' . $tablet_breakpoint . '){
                    .et-db #et-boc .et-l:not(.et-l--footer)>.et_builder_inner_content>.et_pb_section:first-child {padding-top: calc(' . $calculated . 'px + ' . get_content_padding( 'desktop' ) . ')}
                    body>#et-boc>.et_builder_outer_content>.theme-container:first-child {padding-top: ' . $calculated . 'px}
                    body #et-boc .et_builder_inner_content>.theme-container-pwbox:first-child {padding-top: ' . $calculated . 'px}
                    body>#page-container>.theme-container:first-child {padding-top: ' . $calculated . 'px}
                    body.error404>#et-boc>.et_builder_outer_content>.theme-container:first-child {margin-top: ' . $calculated . 'px}
                    body>#page-container>.woocommerce>.theme-container:first-child {padding-top: ' . $calculated . 'px}
                    body>#page-container>.woocommerce>.theme-container.first {padding-top: ' . $calculated . 'px}
					html{scroll-padding-top:' . $calculated . 'px}
                }
            </style>';
			// Standard fixed menu
		else :
			$style .= '<style>@media (min-width:' . get_theme_mod( 'navigation_breakpoint' ) . '){html body {margin-top:' . $calculated . 'px}html{scroll-padding-top:' . $calculated . 'px}}</style>';
		endif;
	endif;

	// [Dev] Todo, When the background is transparent first child doesnt work.
	if ( get_theme_mod( 'mobile_bottom_bar_logo_above_content_toggle' ) !== 1 && strpos( get_theme_mod( 'mobile_navigation_background_color' ), 'rgba' ) !== false && get_theme_mod( 'mobile_navigation_position' ) !== 'bottom' ) :
		$style_mobile = '
		<style>
			@media (max-width:' . $tablet_breakpoint . '){
				.et-db #et-boc .et-l:not(.et-l--footer)>.et_builder_inner_content>.et_pb_section:first-child {padding-top: calc(' . $calculated_mobile . 'px + ' . get_content_padding( 'tablet' ) . ')}
				body>#et-boc>.et_builder_outer_content>.theme-container:first-child {padding-top: ' . $calculated_mobile . 'px}
				body #et-boc .et_builder_inner_content>.theme-container-pwbox:first-child {padding-top: ' . $calculated . 'px}
				body>#page-container>.theme-container:first-child {padding-top: ' . $calculated_mobile . 'px}
				body.error404>#et-boc>.et_builder_outer_content>.theme-container:first-child {margin-top: ' . $calculated_mobile . 'px}
				body>#page-container>.woocommerce>.theme-container:first-child {padding-top: ' . $calculated_mobile . 'px}
				body>#page-container>.woocommerce>.theme-container.first {padding-top: ' . $calculated_mobile . 'px}
				html{scroll-padding-top:' . $calculated_mobile . 'px}
			}
		</style>
		<style>
			@media (max-width:' . $phone_breakpoint . '){
				.et-db #et-boc .et-l:not(.et-l--footer)>.et_builder_inner_content>.et_pb_section:first-child {padding-top: calc(' . $calculated_mobile . 'px + ' . get_content_padding( 'phone' ) . ')}
				html{scroll-padding-top:' . $calculated_mobile . 'px}
			}
		</style>';
		// Standard fixed menu
	elseif ( get_theme_mod( 'mobile_navigation_position' ) !== 'bottom' ) :
		$style_mobile = '<style>@media (max-width:' . $tablet_breakpoint . '){html body {margin-top:' . $calculated_mobile . 'px}}</style>';
	else :
		$style_mobile = '<style>@media (max-width:' . $tablet_breakpoint . '){html body {margin-bottom:' . $calculated_mobile . 'px}}</style>';
	endif;

	// :root {
	// --kls-theme-navigation-height:' . $calculated . 'px;
	// --kls-theme-mobile-navigation-height:' . $calculated_mobile . 'px;
	// }

	$style .= '<style>
		@media (min-width: 980px){
			.sticky-module {
				position: sticky !important;
				top: calc(' . $calculated . 'px + 40px);
				overflow: auto;
				box-sizing: border-box;
				max-height: calc(100vh - 60px - ' . $calculated . 'px);
				transition: .2s !important;
			}
		}
	</style>';

	if ( $header_version == 'shop-v1' || $header_version == 'shop-v1-search' ) {
		$style .= '<style>
			@media (min-width: 980px){
				.sticky-module.sticky-module-header-fixed{
					top: calc(64.8px + 40px);
				}
			}
		</style>';
	}
	if ( ! isset( $style ) ) {
		$style = '';
	}

	if ( ! isset( $style_mobile ) ) {
		$style_mobile = '';
	}

	echo $style . $style_mobile;
}
add_action( 'wp_head', 'kls_set_body_whitespace' );

/**
 * Get the mobile navigation height
 *
 * @param string $mobile_nav Version of the mobile navigation
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.23
 *
 * @return string With the navigation height
 */
function get_the_mobile_navigation_height( $mobile_nav ) {
	if ( ! is_page_template( 'empty-page.php' ) ) :
		$base = 18 / 100 * 170; // The base is calculated as followed: font-size / 100 * line-height in percentage

		$logo_height = get_theme_mod( 'kls_mobile_logo_height' );
		if ( $logo_height && $logo_height > 0 ) :
			$logo_height = preg_replace( '/\D+/', '', $logo_height );
		else :
			$logo_height = 40;
		endif;

		if ( $mobile_nav == 'default-v1' ) :
			$calculated_mobile = 40 + $logo_height;
		elseif ( $mobile_nav == 'bottom_bar-v1' ) :
			$calculated_mobile = 40 + $base;
		elseif ( $mobile_nav == 'bottom_bar_shop-v2' ) :
			$calculated_mobile = 20 + 17 + $base;
		else :
			$calculated_mobile = 40;
		endif;

		return $calculated_mobile;
	endif;
}

/**
 * Get the height of the header.
 *
 * @param string $header Name of the header version to get the height.
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.15
 *
 * @return string With the navigation height
 */
function get_the_header_height( $header ) {
	$header_toggle = get_theme_mod( 'main_navigation_toggle' );

	if ( ! is_page_template( 'empty-page.php' ) && $header_toggle == '1' ) :
		$base = 14 / 100 * 170; // The base is calculated as followed: font-size / 100 * line-height in percentage
		// $base = get_theme_mod('main_navigation_font_size', '14') / 100 * get_theme_mod('kls_main_navigation_line_height', '170'); // Todo, create this to work with the font size and line height. The font size should be stripped of text. The line height should be converted to hunderds. So 1.7em should be 170.

		$logo_height = get_theme_mod( 'kls_logo_height' );
		if ( $logo_height && $logo_height > 0 ) :
			$logo_height = preg_replace( '/\D+/', '', $logo_height );
		else :
			$logo_height = 53;
		endif;

		// Main navigation.
		// [Dev] Todo, convert to switch.
		if ( $header == 'default-v1' ) :
			$main_nav_top_padding    = 40 + $logo_height;
			$main_nav_bottom_padding = 0;
		elseif ( $header == 'default-v1-fullwidth' ) :
			$main_nav_top_padding    = 40 + $logo_height;
			$main_nav_bottom_padding = 0;
		elseif ( $header == 'default-v2-fullwidth' ) :
			$main_nav_top_padding    = 40 + $logo_height;
			$main_nav_bottom_padding = 0;
		elseif ( $header == 'center-v1' ) :
			$main_nav_top_padding    = 40 + $logo_height;
			$main_nav_bottom_padding = 0;
		elseif ( $header == 'shop-v1' || $header == 'shop-v1-search' ) :
			$main_nav_top_padding    = 40 + $logo_height;
			$main_nav_bottom_padding = 41 + $base;
		elseif ( $header == 'shop-v2' ) :
			$main_nav_top_padding = 30 + $logo_height;
			if ( get_theme_mod( 'search_toggle' ) == '1' ) :
				$main_nav_bottom_padding = 30 + 38;
			else :
				$main_nav_bottom_padding = 30 + $base;
			endif;
		elseif ( $header == 'shop-v3' ) :
			$main_nav_top_padding    = 40 + $logo_height;
			$main_nav_bottom_padding = 40 + $base;
		elseif ( $header == 'shop-v4' ) :
			$main_nav_top_padding    = 20 + $logo_height;
			$main_nav_bottom_padding = 20 + $base;
		elseif ( $header == 'shop-v5' ) :
			$main_nav_top_padding    = 0 + $logo_height;
			$main_nav_bottom_padding = 0;
		else :
			$main_nav_top_padding    = 0;
			$main_nav_bottom_padding = 0;
		endif;

		// Top navigation
		if ( get_theme_mod( 'top_navigation_toggle' ) == 1 ) :
			$top_nav = 10 + $base; // Todo, Top nav should get it's own base.
		else :
			$top_nav = 0;
		endif;

		if ( function_exists( 'is_checkout' ) && is_checkout() && get_theme_mod( 'checkout_menu_toggle' ) == 1 ) :
			$main_nav_bottom_padding = 0;
		endif;

		// Combine the data.
		$calculated = $top_nav + $main_nav_top_padding + $main_nav_bottom_padding;

		return $calculated;
	endif;
}

/**
 * Get the padding of the content.
 *
 * @param string $device Desktop, tablet or phone.
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.15
 *
 * @return string
 */
function get_content_padding( $device ) {
	$content       = get_the_content();
	$first_section = get_string_between( $content, '[', ']' );

	if ( $device == 'desktop' ) :
		$start = 'custom_padding="';
	elseif ( $device == 'tablet' && str_contains( $first_section, 'tablet' ) ) :
		$start = 'custom_padding_tablet="';
	elseif ( $device == 'phone' && str_contains( $first_section, 'phone' ) ) :
		$start = 'custom_padding_phone="';
	else :
		$start = 'custom_padding="';
	endif;

	$content    = get_string_between( $first_section, $start, '"' );
	$content    = explode( '|', $content );
	$content    = str_replace( '&#8221;', '', $content );
	$content    = str_replace( '"', '', $content );
	$paddingTop = $content[0];

	if ( $paddingTop > null ) :
		$padding = $paddingTop;
	else :
		$padding = '4%';
	endif;

	return $padding;
}

/**
 * Get the content of a string between a specific start and end character
 *
 * @param string $string The full string.
 * @param string $start Starting character.
 * @param string $end Ending character.
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.15
 *
 * @return string
 */
function get_string_between( $string, $start, $end ) {
	$string = ' ' . $string;
	$ini    = strpos( $string, $start );

	if ( $ini == 0 ) {
		return '';
	}

	$ini += strlen( $start );
	$len  = strpos( $string, $end, $ini ) - $ini;

	return substr( $string, $ini, $len );
}
