<?php
/**
 * Translate theme mods by input.
 *
 * @param string $theme_mod Insert the name of the Theme Mod.
 * @param string $name Insert the name of the string.
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.15
 *
 * @return mixed
 */
function kls_translate_theme_mod( $theme_mod, $name, $default_lang ) {
	$content = get_theme_mod( $theme_mod );
	$local   = 'klasse-theme';

	do_action( 'wpml_register_single_string', $local, $name, $content, false, $default_lang );
	return apply_filters( 'wpml_translate_single_string', $content, $local, $name );
}

/**
 * Translate option by input.
 *
 * @param string $theme_mod Insert the name of the Option.
 * @param string $name Insert the name of the string.
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.15
 *
 * @return mixed
 */
function kls_translate_option( $option, $name, $default_lang ) {
	$content = get_option( $option );
	$local   = 'klasse-theme';

	do_action( 'wpml_register_single_string', $local, $name, $content, false, $default_lang );
	return apply_filters( 'wpml_translate_single_string', $content, $local, $name );
}
