<?php
/**
 * Set customer variables
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.0.04
 */
$customer_logo       = wp_get_attachment_image_src( get_option( 'kls_customer_logo' ), 'full' );
$customer_favicon    = wp_get_attachment_image_src( get_option( 'kls_customer_favicon' ), 'full' );
$customer_name       = get_option( 'kls_customer_name' );
$customer_phone_item = get_option( 'kls_customer_phone' );
$customer_phone_link = preg_replace( '/\D+/', '', $customer_phone_item );
$customer_phone      = '<a href="tel:' . $customer_phone_link . '">' . $customer_phone_item . '</a>';
$customer_mail_item  = get_option( 'kls_customer_email' );
$customer_mail       = '<a href="mailto:' . $customer_mail_item . '">' . $customer_mail_item . '</a>';

/**
 * Include theme public includes
 *
 * @since 0.0.03
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
require_once __DIR__ . '/includes/wordpress/widgets.php';
require_once __DIR__ . '/includes/wordpress/standard_wordpress.php';
require_once __DIR__ . '/includes/wordpress/sticky-header-cls.php';
require_once __DIR__ . '/includes/styling/fonts.php';
require_once __DIR__ . '/includes/shortcodes/shortcodes.php';

// Register custom Divi modules
function custom_divi_register_modules() {
	if ( class_exists( 'ET_Builder_Module' ) ) {
		require_once __DIR__ . '/includes/divi-modules/button.class.php';
	}
}
add_action( 'et_builder_ready', 'custom_divi_register_modules' );

// If theme settings is toggled
if ( get_option( 'kls_theme_settings_toggle' ) == 'on' ) {
	require_once __DIR__ . '/includes/settings/settings.php';
}

if ( get_option( 'kls_webshop_toggle' ) == 'on' && class_exists( 'WooCommerce' ) ) {
	if ( $GLOBALS['theme_style_version'] ) {
		require_once __DIR__ . '/includes/woocommerce/' . $GLOBALS['theme_style_version'] . '/woocommerce.php';
	}

	if ( $GLOBALS['kls_product_style_version'] ) {
		require_once __DIR__ . '/includes/woocommerce/' . $GLOBALS['kls_product_style_version'] . '/product.php';
	}

	if ( $GLOBALS['kls_checkout_flow_style_version'] ) {
		require_once __DIR__ . '/includes/woocommerce/' . $GLOBALS['kls_checkout_flow_style_version'] . '/checkout_flow.php';
		require_once __DIR__ . '/includes/woocommerce/standard_checkout_flow.php';
	}

	require_once __DIR__ . '/includes/woocommerce/standard_woocommerce.php';
	require_once __DIR__ . '/includes/woocommerce/standard_product_archive.php';
	require_once __DIR__ . '/includes/woocommerce/mini_cart.php';
	require_once __DIR__ . '/includes/woocommerce/product_submenu.class.php';
	require_once __DIR__ . '/includes/woocommerce/product_configurator.class.php';
}

if ( get_option( 'kls_action_bar_toggle' ) == 'on' ) {
	require_once __DIR__ . '/includes/actionbar/actionbar.php';
}

// Popup is toggled.
if ( get_option( 'kls_popup_toggle' ) == 'on' && ! is_page_template( 'empty-page.php' ) ) {
	include_once __DIR__ . '/includes/popup/popup.class.php';
}

// WPML
require_once __DIR__ . '/includes/wpml/translation.php';

// FAQ Module
if ( get_option( 'kls_faq_module_toggle' ) == 'on' ) {
	require_once __DIR__ . '/includes/faq/faq_module.class.php';
}

/**
 * Require the customizer
 *
 * @since 0.0.11
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
require_once __DIR__ . '/includes/customizer/customizer.php';

/**
 * Include css styling
 *
 * @since 0.0.04
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_enqueue_style() {
	// General css
	wp_enqueue_style( 'general_theme_css', KT_ASSETS_PATH_PUBLIC_STYLES . 'standard-theme.css', false, $GLOBALS['kls_theme_version'] );

	// form css
	wp_enqueue_style( 'form_css', KT_ASSETS_PATH_PUBLIC_STYLES . 'form/form.css', false, $GLOBALS['kls_theme_version'] );

	// Footer
	wp_enqueue_style( 'footer_css', KT_ASSETS_PATH_PUBLIC_STYLES . 'footer/footer.css', false, $GLOBALS['kls_theme_version'] );
	if ( get_theme_mod( 'footer_toggle' ) == '1' ) :
		wp_enqueue_style( 'footer_theme_css', KT_ASSETS_PATH_PUBLIC_STYLES . 'footer/footer_' . $GLOBALS['kls_footer_version'] . '.css', false, $GLOBALS['kls_theme_version'] );
	endif;

	// General navigation
	if ( get_theme_mod( 'navigation_toggle' ) == '1' ) :
		wp_enqueue_style( 'general_navigation_css', KT_ASSETS_PATH_PUBLIC_STYLES . 'navigation/general_navigation.css', false, $GLOBALS['kls_theme_version'] );
	endif;

	// Main navigation
	if ( get_theme_mod( 'main_navigation_toggle' ) == '1' ) {
		wp_enqueue_style( 'main_navigation_css', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'navigation/main/navigation_' . $GLOBALS['kls_main_navigation_version'] . '.css', false, $GLOBALS['kls_theme_version'] );
	}

	// Sidemenu jQuery
	if ( get_theme_mod( 'kls_sidemenu_navigation_toggle' ) == '1' ) :
		wp_enqueue_script( 'main_navigation_sidemenu_js', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'navigation/side-menu.js', array( 'jquery' ), $GLOBALS['kls_theme_version'] );
		wp_enqueue_style( 'main_navigation_sidemenu_css', KT_ASSETS_PATH_PUBLIC_STYLES . 'navigation/sidemenu/sidemenu_' . get_theme_mod('kls_sidemenu_version', 'v1') . '.css', false, $GLOBALS['kls_theme_version'] );
	endif;

	// sidebar navigation.
	if ( get_theme_mod( 'kls_sidebar_navigation_toggle' ) == '1' ) {
		if ( (get_theme_mod( 'kls_sidebar_only_loggedin' ) == '1' && is_user_logged_in()) || get_theme_mod( 'kls_sidebar_only_loggedin' ) == '0' ) {
			wp_enqueue_style( 'sidebar_navigation_css', KT_ASSETS_PATH_PUBLIC_STYLES . 'navigation/sidebar/sidebar_' . $GLOBALS['kls_sidebar_navigation_version'] . '.css', false, $GLOBALS['kls_theme_version'] );
		}
	}

	// Top navigation
	if ( get_theme_mod( 'top_navigation_toggle' ) == '1' ) {
		wp_enqueue_style( 'top_navigation_css', KT_ASSETS_PATH_PUBLIC_STYLES . 'navigation/top/top_' . $GLOBALS['kls_top_navigation_version'] . '.css', false, $GLOBALS['kls_theme_version'] );
	}

	// Mobile navigation
	if ( get_theme_mod( 'main_navigation_toggle' ) == '1' ) :
		wp_enqueue_style( 'mobile_navigation_css', KT_ASSETS_PATH_PUBLIC_STYLES . 'navigation/general_mobile.css', false, $GLOBALS['kls_theme_version'], '(max-width:' . get_theme_mod( 'navigation_breakpoint' ) . ')' );

		wp_enqueue_style( 'mobile_navigation_' . $GLOBALS['kls_mobile_navigation_version'] . '_css', KT_ASSETS_PATH_PUBLIC_STYLES . 'navigation/mobile/mobile_' . $GLOBALS['kls_mobile_navigation_version'] . '.css', false, $GLOBALS['kls_theme_version'], '(max-width:' . get_theme_mod( 'navigation_breakpoint' ) . ')' );
	endif;

	if ( is_search() ) {
		wp_enqueue_style( 'general_search_css', KT_ASSETS_PATH_PUBLIC_STYLES . 'search/general_search.css', false, $GLOBALS['kls_theme_version'] );
	}

	if ( get_theme_mod( 'search_toggle' ) == '1' ) {
		wp_enqueue_style( 'menu_search_css', KT_ASSETS_PATH_PUBLIC_STYLES . 'search/menu_search.css', false, $GLOBALS['kls_theme_version'] );
	}

	// Reset css
	wp_enqueue_style( 'reset_css', KT_ASSETS_PATH_PUBLIC_STYLES . 'reset.css', false, $GLOBALS['kls_theme_version'] );

	// Submenu jQuery
	if ( get_theme_mod( 'main_navigation_toggle' ) == '1' ) :
		wp_enqueue_script( 'submenu_js', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'navigation/mobile-menu.js', array( 'jquery' ), $GLOBALS['kls_theme_version'] );
	endif;

	// Woocommerce
	if ( get_option( 'kls_webshop_toggle' ) == 'on' && class_exists( 'WooCommerce' ) ) {
		global $post;
		// Standard woocommerce
		wp_enqueue_style( 'kls_standard_general_woocommerce_css', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'woocommerce/standard_general-woocommerce.css', false, $GLOBALS['kls_theme_version'] );
		wp_enqueue_style( 'kls_general_woocommerce_css', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'woocommerce/' . $GLOBALS['theme_style_version'] . '/general_woocommerce.css', false, $GLOBALS['kls_theme_version'] );

		// Mini menu cart
		wp_enqueue_style( 'kls_mini_cart_woocommerce_css', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'woocommerce/' . $GLOBALS['kls_mini_cart_style_version'] . '/mini-cart.css', false, $GLOBALS['kls_theme_version'] );

		// Archive
		if ( is_shop() || is_product_category() || is_product_tag() ) {
			wp_enqueue_style( 'kls_standard_archive_woocommerce_css', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'woocommerce/standard_archive.css', false, $GLOBALS['kls_theme_version'] );
			wp_enqueue_style( 'kls_archive_woocommerce_css', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'woocommerce/' . $GLOBALS['kls_archive_style_version'] . '/archive.css', false, $GLOBALS['kls_theme_version'] );
		}

		// Checkout flow
		wp_enqueue_style( 'kls_standard_checkout_flow_css', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'woocommerce/standard_checkout_flow.css', false, $GLOBALS['kls_theme_version'] );
		wp_enqueue_style( 'kls_checkout_flow_css', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'woocommerce/' . $GLOBALS['kls_checkout_flow_style_version'] . '/checkout_flow.css', false, $GLOBALS['kls_theme_version'] );
		wp_enqueue_script('kls_checkout_flow_js', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'woocommerce/standard_checkout_flow.js', false, $GLOBALS['kls_theme_version']);


		// Cart
		if ( is_cart() ) {
			wp_enqueue_style( 'kls_standard_cart_woocommerce_css', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'woocommerce/standard_cart.css', false, $GLOBALS['kls_theme_version'] );
			wp_enqueue_style( 'kls_cart_woocommerce_css', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'woocommerce/' . $GLOBALS['kls_checkout_flow_style_version'] . '/cart.css', false, $GLOBALS['kls_theme_version'] );
			wp_enqueue_script( 'kls_cart_js', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'woocommerce/standard_cart.js', false, $GLOBALS['kls_theme_version'] );
		}

		// Checkout
		if ( is_checkout() ) {
			wp_enqueue_style( 'kls_standard_checkout_woocommerce_css', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'woocommerce/standard_checkout.css', false, $GLOBALS['kls_theme_version'] );
			wp_enqueue_style( 'kls_checkout_woocommerce_css', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'woocommerce/' . $GLOBALS['kls_checkout_flow_style_version'] . '/checkout.css', false, $GLOBALS['kls_theme_version'] );
			wp_enqueue_script( 'kls_checkout_js', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'woocommerce/standard_checkout.js', false, $GLOBALS['kls_theme_version'] );
		}

		// Single product
		if ( is_product() || defined( 'YITH_WCQV' ) ) {
			wp_enqueue_style( 'kls_standard_product_woocommerce_css', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'woocommerce/standard_product.css', false, $GLOBALS['kls_theme_version'] );
			wp_enqueue_style( 'kls_product_woocommerce_css', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'woocommerce/' . $GLOBALS['kls_product_style_version'] . '/product.css', false, $GLOBALS['kls_theme_version'] );
		}

		// Wishlist menu
		if ( defined( 'YITH_WCWL' ) && get_theme_mod( 'general_menu_wishlist_toggle' ) == '1' ) {
			wp_enqueue_style( 'kls_standard_menu_wishlist_woocommerce_css', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'woocommerce/standard_menu-wishlist.css', false, $GLOBALS['kls_theme_version'] );
			wp_enqueue_style( 'kls_menu_wishlist_woocommerce_css', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'woocommerce/' . $GLOBALS['theme_style_version'] . '/menu-wishlist.css', false, $GLOBALS['kls_theme_version'] );
		}

		// Wishlist
		if ( defined( 'YITH_WCWL' ) && get_option( 'yith_wcwl_wishlist_page_id' ) == get_the_ID() ) {
			wp_enqueue_style( 'kls_standard_wishlist_woocommerce_css', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'woocommerce/standard_wishlist.css', false, $GLOBALS['kls_theme_version'] );
			wp_enqueue_style( 'kls_wishlist_woocommerce_css', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'woocommerce/' . $GLOBALS['theme_style_version'] . '/wishlist.css', false, $GLOBALS['kls_theme_version'] );
		}

		// Giftcard
		if ( function_exists( 'YITH_YWGC' ) ) {
			wp_enqueue_style( 'kls_standard_giftcard_woocommerce_css', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'woocommerce/standard_giftcard.css', false, $GLOBALS['kls_theme_version'] );
			wp_enqueue_style( 'kls_giftcard_woocommerce_css', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'woocommerce/' . $GLOBALS['theme_style_version'] . '/giftcard.css', false, $GLOBALS['kls_theme_version'] );
		}

		// My account menu
		if ( get_theme_mod( 'general_menu_my_account_toggle' ) == '1' ) {
			wp_enqueue_style( 'kls_standard_menu_my_account_woocommerce_css', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'woocommerce/standard_menu-my-account.css', false, $GLOBALS['kls_theme_version'] );
			wp_enqueue_style( 'kls_menu_my_account_woocommerce_css', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'woocommerce/' . $GLOBALS['theme_style_version'] . '/menu-my-account.css', false, $GLOBALS['kls_theme_version'] );
		}

		// My account
		if ( is_account_page() ) {
			wp_enqueue_style( 'kls_standard_my_account_woocommerce_css', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'woocommerce/standard_my-account.css', false, $GLOBALS['kls_theme_version'] );
			wp_enqueue_style( 'kls_my_account_woocommerce_css', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'woocommerce/' . $GLOBALS['theme_style_version'] . '/my-account.css', false, $GLOBALS['kls_theme_version'] );
		}

		// Quickview
		if ( is_account_page() || defined( 'YITH_WCQV' ) ) {
			wp_enqueue_style( 'kls_standard_quickview_woocommerce_css', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'woocommerce/standard_quickview.css', false, $GLOBALS['kls_theme_version'] );
			wp_enqueue_style( 'kls_quickview_woocommerce_css', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'woocommerce/' . $GLOBALS['theme_style_version'] . '/quickview.css', false, $GLOBALS['kls_theme_version'] );
		}

		// Variation accordion.
		if ( 'accordion' == get_theme_mod( 'product_variation_selection_mode_select' ) ) {
			wp_enqueue_style( 'kls_variation_accordion_css', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'woocommerce/variation-accordion.css', false, $GLOBALS['kls_theme_version'] );
		}

		// Standard JS
		wp_enqueue_script( 'kls_standard_general_woocommerce_js', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'woocommerce/standard_general-woocommerce.js', false, $GLOBALS['kls_theme_version'] );

		if (get_theme_mod('kls_product_menu_showcase_toggle', 1) == 1) {
			wp_enqueue_script('kls_product_submenu_script', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'woocommerce/product-submenu.js', false, $GLOBALS['kls_theme_version']);
		}

		// Variation accordion JS.
		if ( 'accordion' == get_theme_mod( 'product_variation_selection_mode_select' ) ) {
			wp_register_script( 'kls_variation_accordion_js', get_template_directory_uri() . '/public/js/variation-accordion.js', false, $GLOBALS['kls_theme_version'], true );

			wp_localize_script(
				'kls_variation_accordion_js',
				'variation_vars',
				array(
					'previous'        => __( 'Previous', 'klasse-theme' ),
					'next'            => __( 'Next', 'klasse-theme' ),
					'selection_error' => __( 'You have not yet made a selection or filled in a field to proceed.', 'klasse-theme' ),
					'add_to_cart_error' => __( 'Please fill in all required fields to add this product to your cart.', 'klasse-theme' ),
				)
			);
			wp_enqueue_script( 'kls_variation_accordion_js' );
		}

		// Product order notes.
		if ( 1 == get_theme_mod( 'kls_cart_notes_toggle' ) ) {
			wp_register_script( 'prefix-script', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'woocommerce/product-order-notes-ajax.js', array( 'jquery-blockui' ), time(), true );
			wp_localize_script(
				'prefix-script',
				'prefix_vars',
				array(
					'ajaxurl' => admin_url( 'admin-ajax.php' ),
				)
			);
			wp_enqueue_script( 'prefix-script' );
		}
	}

	// Admin bar
	if ( is_admin_bar_showing() && get_theme_mod( 'fixed_navigation_toggle' ) == '1' ) {
		wp_enqueue_style( 'kls_admin_bar_css', KT_ASSETS_PATH_ADMIN . 'admin.css', false, $GLOBALS['kls_theme_version'] );
	}

	if ( get_option( 'kls_action_bar_toggle' ) == 'on' ) {
		wp_enqueue_script( 'kls_cookie_script_js', get_template_directory_uri() . '/public/js/js.cookie.min.js', array( 'jquery' ), $GLOBALS['kls_theme_version'], true );
		wp_enqueue_style( 'kls_action_bar', KT_ASSETS_PATH_PUBLIC_STYLES . 'actionbar/actionbar.css', false, $GLOBALS['kls_theme_version'] );
		wp_enqueue_script( 'kls_action_bar_js', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'actionbar/actionbar.js', array( 'jquery' ), $GLOBALS['kls_theme_version'] );
	}

	// Gravity Forms
	if ( get_theme_mod( 'kls_form_label_toggleable_label' ) == '1' ) {
		wp_enqueue_script( 'kls_gravity_forms_label_js', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'gravity-forms/toggleable-label.js', array( 'jquery' ), $GLOBALS['kls_theme_version'] );
	}
}

add_action( 'wp_enqueue_scripts', 'kls_enqueue_style', 999999 );

/**
 * Register Owl Carousel
 *
 * @since 0.0.35
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */

function kls_enqueue_owl_carousel() {
	wp_register_style( 'kls_owl_carousel_style', get_template_directory_uri() . '/includes/add-ons/owl-carousel/assets/owl.carousel.css', array(), $GLOBALS['kls_theme_version'], 'all' );
	wp_register_style( 'kls_owl_carousel_style_theme', get_template_directory_uri() . '/includes/add-ons/owl-carousel/assets/owl.theme.default.css', array(), $GLOBALS['kls_theme_version'], 'all' );
	wp_register_style( 'kls_product_slider_style', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'woocommerce/standard_product-slider.css', array(), $GLOBALS['kls_theme_version'], 'all' );
	wp_register_style( 'kls_product_slider_page_style', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'woocommerce/standard_product-slider-page.css', array(), $GLOBALS['kls_theme_version'], 'all' );
	wp_register_script( 'kls_owl_carousel_script', get_template_directory_uri() . '/includes/add-ons/owl-carousel/owl.carousel.js', false, $GLOBALS['kls_theme_version'] );
	wp_register_script( 'kls_product_slider_script', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'owl-carousel/product.slider.owl.js', false, $GLOBALS['kls_theme_version'] );
	wp_register_script( 'kls_product_slider_page_script', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'owl-carousel/product.slider.page.owl.js', false, $GLOBALS['kls_theme_version'] );
	wp_register_script( 'kls_product_slider_small_script', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'owl-carousel/product.slider.small.owl.js', false, $GLOBALS['kls_theme_version'] );
	wp_register_script( 'kls_category_slider_script', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'owl-carousel/category.slider.owl.js', false, $GLOBALS['kls_theme_version'] );
}
add_action( 'wp_enqueue_scripts', 'kls_enqueue_owl_carousel' );
