<?php

/**
 * Search results page
 *
 * @since 0.0.17
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
get_header(); ?>
<div class="theme-container">
	<?php do_action( 'kls_breadcrumb' ); ?>
	<div class="theme-row">
		<div class="theme-col theme-col-12">
			<?php
			$s    = get_search_query();
			$args = array(
				's' => $s,
			);

			$the_query = new WP_Query( $args );
			if ( $the_query->have_posts() ) {
				?>
				<h1>
					<?php echo sprintf( __( 'Search Results for: %s', 'klasse-theme' ), get_query_var( 's' ) ); ?>
				</h1>
				<?php

				echo get_search_form();

				while ( $the_query->have_posts() ) :
					$the_query->the_post();
					?>
							<li>
								<a href="<?php the_permalink(); ?>" class="button-link"><?php the_title(); ?></a>
							</li>
						<?php
				endwhile;
			} else {
				?>
				<h1><?php _e( 'Nothing Found', 'klasse-theme' ); ?></h1>
				<?php echo get_search_form(); ?>
				<div class="alert alert-info">
				<p><?php _e( 'Sorry, but nothing matched your search criteria. Please try again above with some different keywords.', 'klasse-theme' ); ?></p>
				<a href="/" class="theme-button theme-button-primary"><?php _e( 'Or go back to the homepage', 'klasse-theme' ); ?></a>
				</div>
				<?php
			}
			?>
		</div>
	</div>
</div>

<?php get_footer(); ?>
