<div class="theme-container">
	<div class="theme-row">
		<div class="theme-col theme-col-12">
			<h1>404 - <?php echo __( 'Page not found', 'klasse-theme' ); ?></h1>
			<h2><?php _e( "We can't seem to find the page you're looking for.", 'klasse-theme' ); ?></h2>
			<p>
			<?php
				$menu = wp_nav_menu(
					array(
						'echo'            => false,
						'theme_location'  => '404-menu',
						'container_class' => 'not_found-menu-container',
						'fallback_cb'     => false,
					)
				);
				if ( ! empty( $menu ) ) :
					_e( 'Here are some helpful links instead:', 'klasse-theme' );
					echo $menu;
				endif;
				?>
				</p>
			<?php
			if ( get_theme_mod( '404_search_toggle' ) == '1' ) :
				if ( ! defined( 'YITH_WCAS' ) ) :
					echo get_search_form();
					else :
						echo do_shortcode( '[yith_woocommerce_ajax_search]' );
					endif;
				endif;
			?>

			<a href="/" class="theme-button theme-button-<?php echo get_theme_mod( 'theme_404_button_styling', 'secundary' ); ?>"><?php echo __( 'Back to the homepage', 'klasse-theme' ); ?></a>
		</div>
	</div>
</div>

<style>
	h1 {
		font-size: 40px;
		font-weight: bold;
		line-height: 1.5em;
	}

	h2 {
		line-height: 1.3em;
	}

	.theme-container:not(.footer-top-wrapper) {
		padding-top: 50px;
		padding-bottom: 50px;
	}

	@media (min-width: 980px) {
		.theme-container .theme-row {
			padding-top: 50px;
		}
	}

	.theme-col>.theme-button {
		margin-top: 25px;
	}

	.not_found-menu-container .menu {
		list-style: disc !important;
	}

	@media (max-width: 479px) {
		h1 {
			font-size: 35px;
		}

		h2 {
			font-size: 20px;
		}
	}

	#page-container .theme-container .search-wrapper {
		margin-top: 20px;
		display: inline-block;
		border-bottom: 2px solid #222;
	}

	#page-container .theme-container .search-wrapper input,
	#page-container .theme-container .search-wrapper button {
		border: 0;
		background: transparent;
		color: #222222;
		padding: 10px;
	}

	#page-container .theme-container .search-wrapper button {
		cursor: pointer;
	}

	#page-container .theme-container .search-wrapper input {
		min-width: 200px;
	}

	#page-container .theme-container .search-wrapper i {
		color: #222222;
	}

	.menu-search:hover .menu-search-form-wrapper {
		visibility: visible;
		opacity: 1;
	}
</style>
