<div class="faq-container faq-columns-<?php echo $args['columns']; ?> <?php echo $args['classes'] ?>">
	<?php
	$specific_term_id = $args['term_id'];
	foreach ($args['terms'] as $term) {
		$term_id = $term->term_id;

		if (isset($specific_term_id) && !empty($specific_term_id) && $specific_term_id != $term_id) {
			continue;
		}

		$term_name = $term->name;

		$icon_class = get_term_meta($term_id, 'faq-category-icon', true);
		$icon_html = isset($icon_class) && !empty($icon_class) ? '<i class="' . $icon_class . '"></i>' : '';

		$args = array(
			'post_type' => 'faq',
			'tax_query' => array(
				array(
					'taxonomy' => 'faq_category',
					'field' => 'term_id',
					'terms' => $term_id
				)
			),
		);

		$query = new WP_Query($args);
		?>
		<div class="faq-category">
			<h2>
				<?php echo $icon_html . $term_name; ?>
			</h2>
			<?php
			$i = 0;
			// Todo, get a cap from the shortcode to show a 'Bekijk alle vragen' button to show all the questions.
			if ($query->have_posts()) {
				while ($query->have_posts()) {
					$i++;

					$query->the_post();

					echo get_template_part(
						'/template-parts/faq/item',
						null,
						array(
							'title' => get_the_title(),
							'content' => apply_filters('the_content', get_the_content()),
						)
					);

					// if ($i == 1) {
					// 	echo '<div class="faq-show-all"><i class="fas fa-chevron-down"></i> Show all questions</div>';
					// }
				}
			} else {
				_e("No faq's found.", 'klasse-theme');
			}
			?>
		</div>
		<?php
	}
	?>
</div>

<?php
wp_enqueue_style('kls_faq_module_style');
wp_enqueue_script('kls_faq_module_script');