<nav class="main-nav">
	<div class="main-navigation-wrapper">
		<div class="main-navigation-logo-container">
			<a href="<?php echo esc_url( home_url() ); ?>" class="logo">
				<img src="<?php echo esc_url( $GLOBALS['customer_logo'][0] ); ?>" alt="Logo van <?php echo esc_html( $GLOBALS['customer_name'] ); ?>" width="<?php echo esc_html( $GLOBALS['customer_logo'][1] ); ?>" height="<?php echo esc_html( $GLOBALS['customer_logo'][2] ); ?>" class="logo-img" data-no-lazy="1"/>
			</a>
		</div>
		<div class="main-navigation-wrapper-top">
			<div class="main-navigation-search-wrapper">
				<?php
				if ( get_theme_mod( 'search_toggle' ) == '1' ) :
					if ( ! defined( 'YITH_WCAS' ) ) :
						echo get_search_form();
					else :
						echo do_shortcode( '[yith_woocommerce_ajax_search]' );
					endif;
				endif;
				?>
			</div>

			<div class="main-navigation-secundary-menu-wrapper">
				<?php
				if ( is_user_logged_in() ) :
					wp_nav_menu(
						array(
							'theme_location' => 'secundary',
							'container'      => false,
							'fallback_cb'    => false,
						)
					);
				endif;
				?>
				<div class="nav-menu">
					<?php
					if ( class_exists( 'WooCommerce' ) ) :
						if ( is_user_logged_in() ) :
							if ( get_theme_mod( 'general_menu_my_account_toggle' ) == '1' ) :
								?>
								<div class="menu-my-account">
									<?php echo '<a href="' . esc_attr( get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ) ) . '"' . ' title="' . esc_attr__( 'My account', 'klasse-theme' ) . '"><i class="fas fa-user-alt"></i></a>'; ?>
								</div>
								<?php
							endif;

							if ( defined( 'YITH_WCWL' ) && get_theme_mod( 'general_menu_wishlist_toggle' ) == '1' ) :
								?>
								<div class="menu-wishlist">
									<?php
									$wc_count = yith_wcwl_count_products();
									echo '<a href="' . esc_url( YITH_WCWL()->get_wishlist_url() ) . '"' . ' title="' . esc_attr__( 'Wishlist', 'klasse-theme' ) . '"><i class="fas fa-heart"></i><span class="menu-wishlist-count">' . intval( $wc_count ) . '</span></a>';
									?>
								</div>
							<?php endif; ?>

							<?php
							if ( get_theme_mod( 'general_menu_cart_toggle' ) == '1' ) :
								$items = count( WC()->cart->get_cart() );
								?>
								<div class="menu-cart">
									<div class="menu-cart-icon">
										<i class="fas fa-shopping-cart"></i>
										<div class="menu-cart-count"><span class="cart-count"><?php echo esc_html( WC()->cart->get_cart_contents_count() ); ?></span></div>
										<?php
										if ( $GLOBALS['kls_mini_cart_style_version'] == 'v1' ) :
											?>
											<a href="<?php echo esc_url( wc_get_cart_url() ); ?>" class="cart-link"><span><?php esc_html_e( 'Cart', 'klasse-theme' ); ?></span></a>
											<?php
										else :
											?>
											<div class="cart-link"><span><?php esc_html_e( 'Cart', 'klasse-theme' ); ?></span></div>
											<?php
										endif;
										?>
									</div>

									<?php do_action( 'kls_mini_cart_v1' ); ?>
								</div>
								<?php
							endif;
						else :
							?>
							<a href="<?php echo get_permalink( get_theme_mod( 'kls_main_navigation_v5_button_link', '/' ) ); ?>" class="theme-button theme-button-primary"><?php esc_html_e( 'Request an account', 'klasse-theme' ); ?></a>
							<?php
						endif;
					endif;
					?>
				</div>
			</div>
			<div class="main-navigation-menu-wrapper">
				<?php
					wp_nav_menu(
						array(
							'theme_location' => 'primary',
							'container'      => false,
							'fallback_cb'    => false,
						)
					);
					?>
			</div>
		</div>
	</div>
</nav>
