<?php
// Args from the shortcode
$shortcode_args = $args;
$exclude_id     = $shortcode_args['exclude_id'];
$include_id     = $shortcode_args['include_id'];
$hide           = $shortcode_args['hide_empty'];
$orderby        = $shortcode_args['orderby'];
$order          = $shortcode_args['order'];

// Args for the loop
$args = array(
	'taxonomy'      => 'product_cat',
	'orderby'       => ( $orderby ? $orderby : 'menu_order' ),
	'order'         => ( $order ? $order : 'asc' ),
	'show_count'    => 0,
	'pad_count'     => 0,
	'hierarchical ' => 0,
	'hide_empty'    => $hide,
);

$loop           = new WP_Query( $args );
$all_categories = get_categories( $args );

echo '<div class="owl-carousel owl-carousel-category owl-theme">';
foreach ( $all_categories as $cat ) {
	if ( $cat->category_parent == 0 ) {
		if ( isset( $exclude_id ) && ! in_array( $cat->term_id, $exclude_id ) || isset( $include_id ) && in_array( $cat->term_id, $include_id ) ) {
			$thumbnail_id   = get_term_meta( $cat->term_id, 'thumbnail_id', true );
			$cat_short_desc = get_term_meta( $cat->term_id, 'kls_short_desc', true );
			echo '
            <div class="item category-slider-item">
                <a href="' . get_term_link( $cat->slug, 'product_cat' ) . '">
                    <div class="category-slider-item-image-container">
                        <div class="category-slider-item-image"><img src="' . wp_get_attachment_image_url( $thumbnail_id, 'category-slider-image' ) . '" data-no-lazy="1"></div>
                    </div>
                    <div class="category-slider-item-content-container">
                        <div class="category-slider-item-content">
                            <p><strong>' . $cat->name . '</strong> <i class="fas fa-long-arrow-alt-right"></i><br>
                            ' . $cat_short_desc . '</p>
                        </div>
                    </div>
                </a>
            </div>';
		}
	}
};
echo '</div>';

wp_reset_query();

// Enqueue Owl carousel
wp_enqueue_style( 'kls_owl_carousel_style' );
wp_enqueue_style( 'kls_owl_carousel_style_theme' );
wp_enqueue_script( 'kls_owl_carousel_script' );
wp_enqueue_script( 'kls_category_slider_script' );
