<?php
// Args from the shortcode
$shortcode_args = $args;
$orderby        = $shortcode_args['orderby'];
$order          = $shortcode_args['order'];
$maximum        = $shortcode_args['maximum'];

// Args for the loop
$args = array(
	'posts_per_page' => -1,
	'post_type'      => 'product',
	'post_status'    => 'publish',
	'orderby'        => ( $orderby ? $orderby : 'menu_order' ),
	'order'          => ( $order ? $order : 'ASC' ),
	'tax_query'      => array(
		array(
			'taxonomy' => 'product_visibility',
			'field'    => 'name',
			'terms'    => 'featured',
			'operator' => 'IN',
		),
	),
);

$loop = new WP_Query( $args );
$i    = 0;

echo '<div class="product-block-container">';
while ( $loop->have_posts() ) :
	$loop->the_post();
	if ( ++$i == ( $maximum + 1 ) ) {
		break;
	}

	global $product;
	echo '
    <div class="product-block-item-container">
        <div class="product-block-item-wishlist">' . do_shortcode( '[yith_wcwl_add_to_wishlist]' ) . '</div>
        <a href="' . get_permalink() . '">
            <div class="product-block-item-image-container">
                <div class="product-block-item-image">' . woocommerce_get_product_thumbnail( 'product-slider-thumbnail', 450 ) . '</div>
            </div>
            <div class="product-block-item-content-container">
                <div class="product-block-item-content">
                    <div class="product-block-item-title">' . get_the_title() . '</div>
                    <div class="product-block-item-text">' . apply_filters( 'woocommerce_short_description', $product->get_short_description() ) . '</div>
                </div>
                <div class="product-block-item-content-button">
                    ' . __( 'View more', 'klasse-theme' ) . ' <i class="fas fa-long-arrow-alt-right"></i>
                </div>
            </div>
        </a>
    </div>';
endwhile;
echo '</div>';

wp_reset_query();

// Add SyncSilo script
if ( get_option( 'kls_syncsilo_compatibility_toggle' ) == 'on' && defined( 'YITH_WCQV' ) ) :
	wp_enqueue_script( 'wwa_pc/js/wp.hooks', 'https://js-cdn.syncsilo.com/wwa-configurator.min.js', array(), $GLOBALS['kls_theme_version'] );
endif;
