<?php
// Args from the shortcode
$shortcode_args = $args;
$orderby        = $shortcode_args['orderby'];
$order          = $shortcode_args['order'];
$maximum        = $shortcode_args['maximum'];
$exclude_id     = ( $shortcode_args['exclude_id'] ? $shortcode_args['exclude_id'] : array() );

// Args for the loop
$args = array(
	'posts_per_page' => -1,
	'post_type'      => 'product',
	'post_status'    => 'publish',
	'order'          => ( $order ? $order : 'ASC' ),
	'meta_key'       => 'total_sales',
	'orderby'        => $orderby,
);

$loop = new WP_Query( $args );

add_image_size( 'product-slider-small-thumbnail', '300', '300', false );

echo '<div class="owl-carousel owl-carousel-product owl-theme">';
$i = 0;
while ( $loop->have_posts() ) :
	$loop->the_post();
	global $product;
	if ( ! in_array( $product->get_id(), $exclude_id ) ) {
		if ( ++$i == ( $maximum + 1 ) ) {
			break;
		}

		if ( $product->get_price() <= 0.01 ) :
			$pricing = __( 'View this product', 'klasse-theme' );
		else :
			$pricing = __( 'From', 'klasse-theme' ) . ' ' . get_woocommerce_currency_symbol() . $product->get_price();
		endif;
		$terms    = get_the_terms( $product->get_id(), 'product_cat' );
		$category = $terms[0]->name;
		echo '
        <div class="item product-slider-item product-slider-item-small">
            <div class="product-slider-item-wishlist">' . do_shortcode( '[yith_wcwl_add_to_wishlist]' ) . '</div>
            <a href="' . get_permalink() . '">
                <div class="product-slider-item-image-container">
                    <div class="product-slider-item-image">' . woocommerce_get_product_thumbnail( 'product-slider-small-thumbnail', 450 ) . '</div>
                </div>
                <div class="product-slider-item-content-container">
                    <div class="product-slider-item-content">
                        <div class="product-slider-item-category">' . $category . '</div>
                        <div class="product-slider-item-title">' . get_the_title() . '</div>
                        <div class="product-slider-item-price">' . $pricing . '</div>
                    </div>
                    <div class="product-slider-item-content-icon">
                        <i class="fas fa-long-arrow-alt-right"></i>
                    </div>
                </div>
            </a>
        </div>';
	}
endwhile;
echo '</div>';

wp_reset_query();

// Enqueue Owl carousel
wp_enqueue_style( 'kls_owl_carousel_style' );
wp_enqueue_style( 'kls_owl_carousel_style_theme' );
wp_enqueue_style( 'kls_product_slider_style' );
wp_enqueue_script( 'kls_owl_carousel_script', array( 'jquery' ), $GLOBALS['kls_theme_version'] );
wp_enqueue_script( 'kls_product_slider_small_script', array( 'jquery' ), $GLOBALS['kls_theme_version'] );

// Add SyncSilo script
if ( get_option( 'kls_syncsilo_compatibility_toggle' ) == 'on' && defined( 'YITH_WCQV' ) ) :
	wp_enqueue_script( 'wwa_pc/js/wp.hooks', 'https://js-cdn.syncsilo.com/wwa-configurator.min.js', array(), $GLOBALS['kls_theme_version'] );
endif;
