<?php
// Args from the shortcode
$shortcode_args = $args;
$orderby        = $shortcode_args['orderby'];
$order          = $shortcode_args['order'];

// Args for the loop
$args = array(
	'posts_per_page' => -1,
	'post_type'      => 'product',
	'post_status'    => 'publish',
	'orderby'        => ( $orderby ? $orderby : 'menu_order' ),
	'order'          => ( $order ? $order : 'ASC' ),
	'tax_query'      => array(
		array(
			'taxonomy' => 'product_visibility',
			'field'    => 'name',
			'terms'    => 'featured',
			'operator' => 'IN',
		),
	),
);

$loop = new WP_Query( $args );

echo '<div class="owl-carousel owl-carousel-product owl-theme">';
while ( $loop->have_posts() ) :
	$loop->the_post();
	global $product;
	if ( $product->get_price() <= 0.01 ) :
		$pricing = __( 'View this product', 'klasse-theme' );
	else :
		$pricing = __( 'From', 'klasse-theme' ) . ' ' . get_woocommerce_currency_symbol() . $product->get_price();
	endif;

	if ( defined( 'YITH_WCWL' ) ) :
		$wishlist = '<div class="product-slider-item-wishlist">' . do_shortcode( '[yith_wcwl_add_to_wishlist]' ) . '</div>';
	else :
		$wishlist = '';
	endif;

	echo '
    <div class="item product-slider-item">
    	' . $wishlist . '
        <a href="' . get_permalink() . '">
            <div class="product-slider-item-image-container">
                <div class="product-slider-item-image">' . woocommerce_get_product_thumbnail( 'product-slider-thumbnail', 450 ) . '</div>
            </div>
            <div class="product-slider-item-content-container">
                <div class="product-slider-item-content">
                    <div class="product-slider-item-title">' . get_the_title() . '</div>
                    <div class="product-slider-item-price">' . $pricing . '</div>
                </div>
                <div class="product-slider-item-content-icon">
                    <i class="fas fa-long-arrow-alt-right"></i>
                </div>
            </div>
        </a>
    </div>';
endwhile;
echo '</div>';

wp_reset_query();

// Enqueue Owl carousel
wp_enqueue_style( 'kls_owl_carousel_style' );
wp_enqueue_style( 'kls_owl_carousel_style_theme' );
wp_enqueue_style( 'kls_product_slider_style' );
wp_enqueue_script( 'kls_owl_carousel_script', array( 'jquery' ), $GLOBALS['kls_theme_version'] );
wp_enqueue_script( 'kls_product_slider_script', array( 'jquery' ), $GLOBALS['kls_theme_version'] );

// Add SyncSilo script
if ( get_option( 'kls_syncsilo_compatibility_toggle' ) == 'on' && defined( 'YITH_WCQV' ) ) :
	wp_enqueue_script( 'wwa_pc/js/wp.hooks', 'https://js-cdn.syncsilo.com/wwa-configurator.min.js', array(), $GLOBALS['kls_theme_version'] );
endif;
