<?php
defined( 'ABSPATH' ) || exit;

do_action( 'kls_before_archive' );
?>
<div class="theme-row">
	<?php
	if ( get_theme_mod( 'archive_sidebar_toggle' ) == 1 ) :
		?>
	<div class="theme-col theme-col-3 sidebar-col theme-col-archive">
		<?php
		/**
		 * Hook: woocommerce_sidebar.
		 *
		 * @hooked woocommerce_get_sidebar - 10
		 */
		do_action( 'woocommerce_sidebar' );
		?>
		</div>
		<div class="theme-col theme-col-9 theme-col-archive">
		<?php
		else :
			?>
		<div class="theme-col theme-col-12">
			<?php
		endif;
		if ( woocommerce_product_loop() ) {
			/**
			 * Hook: woocommerce_before_shop_loop.
			 *
			 * @hooked woocommerce_output_all_notices - 10
			 * @hooked woocommerce_result_count - 20
			 * @hooked woocommerce_catalog_ordering - 30
			 */
				do_action( 'woocommerce_before_shop_loop' );

			if ( get_theme_mod( 'kls_archive_show_sorting', 1 ) == 1 && get_theme_mod( 'archive_sidebar_toggle' ) == 1 ) :
				?>
				<div class="before-shop-wrapper">
					<?php if ( get_theme_mod( 'archive_sidebar_toggle' ) == 1 ) : ?>
						<button class="sidebar-toggle">
							<i class="fas fa-filter"></i> 
							<span>
								<?php esc_html_e( 'Filter', 'klasse-theme' ); ?>
							</span>
						</button>
					<?php endif; ?>
					<?php do_action( 'kls_before_shop_loop' ); ?>
				</div>
				<?php
			endif;

			woocommerce_product_loop_start();
			if ( wc_get_loop_prop( 'total' ) ) {
				while ( have_posts() ) {
					the_post();

					/**
					 * Hook: woocommerce_shop_loop.
					 */
					do_action( 'woocommerce_shop_loop' );
					wc_get_template_part( 'content', 'product' );
				}
			}

			woocommerce_product_loop_end();
			?>
			<div class="after-shop-wrapper">
				<?php
				/**
				 * Hook: woocommerce_after_shop_loop.
				 *
				 * @hooked woocommerce_pagination - 10
				 */
				do_action( 'woocommerce_after_shop_loop' );
				?>
			</div>
			<?php
		} else {
			?>
			<?php
				/**
				 * Hook: woocommerce_no_products_found.
				 *
				 * @hooked wc_no_products_found - 10
				 */
				do_action( 'woocommerce_no_products_found' );
		}
		?>

			<div class="woocommerce-products-description">
				<?php
				/**
				 * Hook: woocommerce_archive_description.
				 *
				 * @hooked woocommerce_taxonomy_archive_description - 10
				 * @hooked woocommerce_product_archive_description - 10
				 */
				do_action( 'woocommerce_archive_description' );
				?>
			</div>
		</div>
	</div>
</div>

<?php
do_action( 'kls_after_archive' );
