<?php

/**
 * Mini-cart
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 5.2.0
 */

defined( 'ABSPATH' ) || exit;

do_action( 'woocommerce_before_mini_cart' );

if ( ! WC()->cart->is_empty() ) :
	?>

	<ul class="woocommerce-mini-cart cart_list product_list_widget <?php echo esc_attr( $args['list_class'] ); ?>">
		<?php
		do_action( 'woocommerce_before_mini_cart_contents' );
		foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
			$_product   = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
			$product_id = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );
			if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_widget_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
				$product_name      = apply_filters( 'woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key );
				$thumbnail         = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );
				$product_price     = apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key );
				$product_permalink = apply_filters( 'woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink( $cart_item ) : '', $cart_item, $cart_item_key );
				?>
				<li class="woocommerce-mini-cart-item <?php echo esc_attr( apply_filters( 'woocommerce_mini_cart_item_class', 'mini_cart_item', $cart_item, $cart_item_key ) ); ?>">
					<?php if ( empty( $product_permalink ) ) : ?>
						<div class="mini-cart-item-image">
								<?php echo $thumbnail; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
						</div>
					<?php else : ?>
						<div class="mini-cart-item-image">
							<a href="<?php echo esc_url( $product_permalink ); ?>">
								<?php echo $thumbnail; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
							</a>
						</div>
					<?php endif; ?>
					<div class="mini-cart-item-details">
						<a href="<?php echo esc_url( $product_permalink ); ?>" class="mini-cart-item-title">
							<?php echo $cart_item['quantity'] . ' &times; ' . wp_kses_post( $product_name ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
						</a>
						<?php echo wc_get_formatted_cart_item_data( $cart_item ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
						<?php
						echo $product_price;

						echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
							'woocommerce_cart_item_remove_link',
							sprintf(
								'<a href="%s" class="mini-cart-remove" aria-label="%s" data-product_id="%s" data-cart_item_key="%s" data-product_sku="%s"><i class="fas fa-trash"></i></a>',
								esc_url( wc_get_cart_remove_url( $cart_item_key ) ),
								esc_attr__( 'Remove this item', 'klasse-theme' ),
								esc_attr( $product_id ),
								esc_attr( $cart_item_key ),
								esc_attr( $_product->get_sku() )
							),
							$cart_item_key
						);
						?>
					</div>
				</li>
				<?php
			}
		}

		do_action( 'woocommerce_mini_cart_contents' );
		?>
	</ul>
	<div class="mini-cart-totals">


		<p class="woocommerce-mini-cart__total total">
				<?php
				/**
				 * Hook: woocommerce_widget_shopping_cart_total.
				 *
				 * @hooked woocommerce_widget_shopping_cart_subtotal - 10
				 */
				do_action( 'woocommerce_widget_shopping_cart_total' );
				?>
		</p>
		<?php do_action( 'woocommerce_widget_shopping_cart_before_buttons' ); ?>

		<a href="<?php echo wc_get_cart_url(); ?>" class="theme-button theme-button-full-width theme-button-primary"><?php esc_html_e( 'Continue ordering', 'klasse-theme' ); ?></a>
		<a href="<?php echo get_permalink( wc_get_page_id( 'shop' ) ); ?>" class="theme-button theme-button-full-width theme-button-secundary mini-cart-close"><?php esc_html_e( 'Continue shopping', 'klasse-theme' ); ?></a>
		<div class="mini-cart-small-actions">
			<a href="?clear-cart" class="button-link"><?php esc_html_e( 'Empty cart', 'klasse-theme' ); ?></a> | <a href="<?php echo wc_get_cart_url(); ?>" class="button-link"><?php esc_html_e( 'View cart', 'klasse-theme' ); ?></a>
		</div>

		<?php do_action( 'woocommerce_widget_shopping_cart_after_buttons' ); ?>
	</div>
	<?php
else :
	?>
	<div class="mini-cart-empty-container">
		<p class="woocommerce-mini-cart__empty-message"><?php esc_html_e( 'No products in the cart.', 'klasse-theme' ); ?></p>
	</div>
	<div class="mini-cart-empty-container">
		<a href="<?php echo get_permalink( wc_get_page_id( 'shop' ) ); ?>" class="mini-cart-empty-button button empty"><?php esc_html_e( 'Continue shopping', 'klasse-theme' ); ?></a>
	</div>
<?php endif; ?>

<?php
do_action( 'woocommerce_after_mini_cart' );
