<div class="theme-container first">
	<?php
	do_action( 'woocommerce_before_checkout_form', $args['checkout'] );

	// If checkout registration is disabled and not logged in, the user cannot checkout.
	if ( ! $args['checkout']->is_registration_enabled() && $args['checkout']->is_registration_required() && ! is_user_logged_in() ) {
		echo esc_html( apply_filters( 'woocommerce_checkout_must_be_logged_in_message', __( 'You must be logged in to checkout.', 'klasse-theme' ) ) );
		return;
	}?>

<form name="checkout" method="post" class="checkout woocommerce-checkout" action="<?php echo esc_url( wc_get_checkout_url() ); ?>" enctype="multipart/form-data">
	<div class="theme-row">
		<?php if ( $args['checkout']->get_checkout_fields() ) : ?>
			<div class="theme-col theme-col-7">
				<?php do_action( 'woocommerce_checkout_before_customer_details' ); ?>

				<div class="checkout-customer-details" id="customer_details">
					<?php do_action( 'woocommerce_checkout_billing' ); ?>
					<?php do_action( 'woocommerce_checkout_shipping' ); ?>
				</div>

				<?php do_action( 'woocommerce_checkout_after_customer_details' ); ?>
			</div>
		<?php endif; ?>

		<div class="theme-col theme-col-5">
			<div class="checkout-totals">
				<?php do_action( 'woocommerce_checkout_before_order_review_heading' ); ?>
				
				<h2 id="order_review_heading"><?php esc_html_e( 'Your order', 'klasse-theme' ); ?></h2>
				
				<?php do_action( 'woocommerce_checkout_before_order_review' ); ?>

				<div id="order_review" class="woocommerce-checkout-review-order">
					<?php do_action( 'woocommerce_checkout_order_review' ); ?>
				</div>

				<?php do_action( 'woocommerce_checkout_after_order_review' ); ?>
			</div>
		</div>
	</div>
</form>
<?php
do_action( 'woocommerce_after_checkout_form', $args['checkout'] );
?>
</div>
