<div class="theme-container background-color first">
	<div class="theme-row">
		<div class="theme-col theme-col-12">
			<h1><strong><?php esc_html_e( 'Complete order', 'klasse-theme' ); ?></strong></h1>
		</div>
	</div>

	<?php
	do_action( 'woocommerce_before_checkout_form', $args['checkout'] );

	// If checkout registration is disabled and not logged in, the user cannot checkout.
	if ( ! $args['checkout']->is_registration_enabled() && $args['checkout']->is_registration_required() && ! is_user_logged_in() ) {
		echo esc_html( apply_filters( 'woocommerce_checkout_must_be_logged_in_message', __( 'You must be logged in to checkout.', 'klasse-theme' ) ) );
		return;
	}
	?>

	<form name="checkout" method="post" class="checkout woocommerce-checkout" action="<?php echo esc_url( wc_get_checkout_url() ); ?>" enctype="multipart/form-data">
		<div class="theme-row">
			<?php

			if ( $args['checkout']->get_checkout_fields() ) :
				?>
				<div class="theme-col theme-col-8">
					<?php
					echo get_template_part( '/template-parts/woocommerce/checkout-breadcrumb', $GLOBALS['kls_checkout_flow_style_version'] );
					do_action( 'woocommerce_checkout_before_customer_details' );
					?>

					<div class="checkout-customer-details woocommerce-cart-container" id="customer_details">
						<?php
						// if ( 1 == get_theme_mod( '' ) ) {
						?>
						<div class="cart-text-container">
							<div class="cart-text-container-icon">
								<i class="fas fa-box-open"></i>
							</div>
							<div class="cart-text-container-text">
								<h2><?php esc_html_e( 'Address information', 'klasse-theme' ); ?></h2>
								<p><?php esc_html_e( 'Enter the delivery address here.', 'klasse-theme' ); ?></p>
							</div>
						</div>
						<?php
						// }
						?>
						<div class="woocommerce-cart-shipping-item">
							<?php do_action( 'woocommerce_checkout_billing' ); ?>
							<?php do_action( 'woocommerce_checkout_shipping' ); ?>
						</div>
					</div>

					<?php do_action( 'woocommerce_checkout_after_customer_details' ); ?>
					<div class="woocommerce-cart-container woocommerce-cart-shipping-methodes-container">
						<?php
						// if ( 1 == get_theme_mod( '' ) ) {
						?>
						<div class="cart-text-container">
							<div class="cart-text-container-icon">
								<i class="fas fa-truck"></i>
							</div>
							<div class="cart-text-container-text">
								<div class="cart-text-container-text">
									<h2><?php esc_html_e( 'Shipping', 'klasse-theme' ); ?></h2>
									<p><?php esc_html_e( 'Choose the desired shipping method to have your order delivered.', 'klasse-theme' ); ?></p>
								</div>
							</div>
						</div>
						<?php
						// }
						?>
						<div class="woocommerce-cart-shipping-item">
							<table>
								<?php if ( WC()->cart->needs_shipping() && WC()->cart->show_shipping() ) : ?>
									<?php do_action( 'woocommerce_review_order_before_shipping' ); ?>

									<?php wc_cart_totals_shipping_html(); ?>

									<?php do_action( 'woocommerce_review_order_after_shipping' ); ?>
								<?php elseif ( WC()->cart->needs_shipping() && 'yes' === get_option( 'woocommerce_enable_shipping_calc' ) ) : ?>
									<tr class="shipping">
										<td data-title="<?php esc_attr_e( 'Shipping', 'klasse-theme' ); ?>"><?php woocommerce_shipping_calculator(); ?></td>
									</tr>
								<?php endif; ?>
							</table>
						</div>
					</div>

					<?php if ( WC()->cart->needs_payment() ) : ?>
						<div class="woocommerce-cart-container woocommerce-cart-billing-methodes-container">
							<?php
							// if ( 1 == get_theme_mod( '' ) ) {
							?>
							<div class="cart-text-container">
								<div class="cart-text-container-icon">
									<i class="fas fa-credit-card"></i>
								</div>
								<div class="cart-text-container-text">
									<h2><?php esc_html_e( 'Payment method', 'klasse-theme' ); ?></h2>
									<p><?php esc_html_e( 'Choose the desired payment method here.', 'klasse-theme' ); ?></p>
								</div>
							</div>
							<?php
							// }
							?>
							<div class="woocommerce-cart-shipping-item">
								<table>
									<?php if ( WC()->cart->needs_payment() ) : ?>
										<ul class="wc_payment_methods payment_methods methods">
											<?php
											$gateways = WC()->payment_gateways()->get_available_payment_gateways();
											if ( ! empty( $gateways ) ) {
												foreach ( $gateways as $gateway ) {
													wc_get_template( 'checkout/payment-method.php', array( 'gateway' => $gateway ) );
												}
											} else {
												echo '<li class="woocommerce-notice woocommerce-notice--info woocommerce-info">' . apply_filters( 'woocommerce_no_available_payment_methods_message', WC()->customer->get_billing_country() ? esc_html__( 'Sorry, it seems that there are no available payment methods for your state. Please contact us if you require assistance or wish to make alternate arrangements.', 'klasse-theme' ) : esc_html__( 'Please fill in your details above to see available payment methods.', 'klasse-theme' ) ) . '</li>'; // @codingStandardsIgnoreLine
											}
											?>
										</ul>
									<?php endif; ?>
								</table> 
							</div>
						</div>
					<?php endif; ?>
				</div>
			<?php endif; ?>

			<div class="theme-col theme-col-4">
				<div class="checkout_flow_totals checkout-totals sticky-module">
					<?php do_action( 'woocommerce_checkout_before_order_review_heading' ); ?>
										
					<?php do_action( 'woocommerce_checkout_before_order_review' ); ?>

					<div id="order_review" class="woocommerce-checkout-review-order">
						<?php do_action( 'woocommerce_checkout_order_review' ); ?>
					</div>

					<?php do_action( 'woocommerce_checkout_after_order_review' ); ?>
				</div>
			</div>
		</div>
	</form>
	<?php
	do_action( 'woocommerce_after_checkout_form', $args['checkout'] );
	?>
</div>
