<?php
/**
 * Checkout coupon form
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

defined( 'ABSPATH' ) || exit;

if ( ! wc_coupons_enabled() ) { // @codingStandardsIgnoreLine.
	return;
}

?>
<div class="theme-row">
	<div class="theme-col theme-col-12" style="padding: 0;">
		<div class="woocommerce-form-coupon-toggle" style="display: none;">
			<?php echo esc_html__( 'Have a coupon?', 'klasse-theme' ) . ' <a href="#" class="showcoupon button-link">' . esc_html__( 'Click here to enter your code', 'klasse-theme' ) . '</a>'; ?>
		</div>

		<form class="checkout_coupon woocommerce-form-coupon" id="checkout_coupon_form" method="post" style="display:none">

			<p><?php esc_html_e( 'If you have a coupon code, please apply it below.', 'klasse-theme' ); ?></p>

			<p class="form-row form-row-first"><input type="text" name="coupon_code" class="input-text" placeholder="<?php esc_attr_e( 'Coupon code', 'klasse-theme' ); ?>" id="coupon_code" value="" /></p>
			<p class="form-row form-row-last"><button type="submit" class="button theme-button theme-button-secundary" name="apply_coupon" value="<?php esc_attr_e( 'Apply coupon', 'klasse-theme' ); ?>"><?php esc_html_e( 'Apply coupon', 'klasse-theme' ); ?></button></p>

			<div class="clear"></div>
		</form>
	</div>
</div>
