<?php
defined( 'ABSPATH' ) || exit;

global $product;

if ( get_theme_mod( 'kls_product_banner_toggle', 0 ) == 1 ) :
	?>
	<div class="theme-container theme-banner theme-product-banner">
		<?php
		if ( ! wp_attachment_is_image( get_theme_mod( 'kls_product_banner_background_image' ) ) ) {
			?>
			<video autoplay muted loop>
				<source src="<?php echo esc_url_raw( wp_get_attachment_url( get_theme_mod( 'kls_product_banner_background_image', '' ) ) ); ?>" type=" <?php echo wp_check_filetype( wp_get_attachment_url( get_theme_mod( 'kls_product_banner_background_image', '' ) ) )['type']; ?>">
			</video>
			<?php
		}
		?>
		<div class="theme-row">
			<div class="theme-col-12">
				<h1 class="product_title entry-title"><?php echo esc_html( get_the_title() ); ?></h1>
				<div class="breadcrumb">
				<?php
				if ( function_exists( 'woocommerce_breadcrumb' ) ) {
					$args = array(
						'delimiter' => ' / ',
					);
					woocommerce_breadcrumb( $args );
				} elseif ( function_exists( 'yoast_breadcrumb' ) ) {
					yoast_breadcrumb();
				}
				?>
				</div>
			</div>
		</div>
	</div>
<?php else : ?>
	<div class="theme-container <?php echo ( get_theme_mod( 'kls_product_first_container_background', 1 ) == 1 && get_theme_mod( 'kls_product_sidebar_toggle', 1 ) == 1 ? 'background-color' : '' ); ?> theme-breadcrumb-container">
		<?php do_action( 'kls_breadcrumb' ); ?>
	</div>
<?php endif; ?>

<div id="product-<?php the_ID(); ?>" <?php wc_product_class( '', $product ); ?>>
	<div class="theme-container <?php echo ( get_theme_mod( 'kls_product_first_container_background', 1 ) == 1 && get_theme_mod( 'kls_product_sidebar_toggle', 1 ) == 1 ? 'background-color' : '' ); ?>">
		<?php

		/**
		 * Hook: woocommerce_before_single_product.
		 *
		 * @hooked woocommerce_output_all_notices - 10
		 */

		do_action( 'woocommerce_before_single_product' );
		?>
		<?php if ( get_theme_mod( 'kls_product_sidebar_toggle', 1 ) == 1 ) : ?>
		<div class="theme-row">
			<div class="theme-col theme-col-9">
			<?php endif; ?>
				<div class="theme-row">
					<div class="theme-col theme-col-<?php echo esc_html( get_theme_mod( 'kls_product_image_width', '4' ) ); ?>">
					<?php
						/**
						 * Hook: woocommerce_before_single_product_summary.
						 *
						 * @hooked woocommerce_show_product_sale_flash - 10
						 * @hooked woocommerce_show_product_images - 20
						 */
						do_action( 'woocommerce_before_single_product_summary' );
					?>
					</div>

					<div class="theme-col theme-col-<?php echo esc_html( get_theme_mod( 'kls_product_summary_width', '8' ) ); ?>">
						<div class="summary entry-summary">
						<?php
							/**
							 * Hook: woocommerce_single_product_summary.
							 *
							 * @hooked woocommerce_template_single_title - 5
							 * @hooked woocommerce_template_single_rating - 10
							 * @hooked woocommerce_template_single_price - 10
							 * @hooked woocommerce_template_single_excerpt - 20
							 * @hooked woocommerce_template_single_add_to_cart - 30
							 * @hooked woocommerce_template_single_meta - 40
							 * @hooked woocommerce_template_single_sharing - 50
							 * @hooked WC_Structured_Data::generate_product_data() - 60
							 */
							do_action( 'woocommerce_single_product_summary' );
						?>
						</div>
					</div>

		<?php if ( get_theme_mod( 'kls_product_sidebar_toggle', 1 ) == 0 ) : ?>
				</div>
			</div>
			<div class="theme-container <?php echo ( get_theme_mod( 'kls_product_first_container_background', 1 ) == 1 ? 'background-color' : '' ); ?>">
				<div class="theme-row">
			<?php endif; ?>
					<div id="order" class="theme-col theme-col-12">
						<?php
						do_action( 'kls_product_tabs' );
						?>
					</div>
				</div>
			<?php if ( get_theme_mod( 'kls_product_sidebar_toggle', 1 ) == 1 ) : ?>
			</div>
			<div class="theme-col theme-col-3">
				<div class="product-sidebar-container">
					<h3><?php esc_html_e( 'We are ready for you', 'klasse-theme' ); ?></h3>
					<ul>
						<?php if ( get_option( 'kls_customer_phone' ) ) : ?>
							<li class="product-sidebar-item">
								<div class="product-sidebar-item-container">
									<i class="fas fa-headset"></i>
									<p><strong><?php esc_html_e( 'Questions? Call us', 'klasse-theme' ); ?></strong><span><a href="tel:<?php echo get_option( 'kls_customer_phone' ); ?>"><?php echo get_option( 'kls_customer_phone' ); ?></a></span></p>
								</div>
							</li>
						<?php endif; ?>
						<?php if ( get_option( 'kls_customer_email' ) ) : ?>
							<li class="product-sidebar-item">
								<div class="product-sidebar-item-container">
									<i class="fas fa-envelope"></i>
									<p><strong><?php esc_html_e( 'Send a message', 'klasse-theme' ); ?></strong><span><a href="mailto:<?php echo get_option( 'kls_customer_email' ); ?>"><?php echo get_option( 'kls_customer_email' ); ?></a></span></p>
								</div>
							</li>
							<?php
						endif;

						if ( get_theme_mod( 'kls_product_sidebar_link_one' ) ) :
							$theme_option = get_theme_mod( 'kls_product_sidebar_link_one' );
							$option_slug  = get_permalink( $theme_option );
							$option_title = ( ! empty( get_theme_mod( 'kls_product_sidebar_link_one_text_in_link' ) ) ? kls_translate_theme_mod( 'kls_product_sidebar_link_one_text_in_link', 'Sidebar link text in link one', 'nl' ) : get_the_title( $theme_option ) );
							?>
							<li class="product-sidebar-item">
								<div class="product-sidebar-item-container">
									<i class="<?php echo get_theme_mod( 'kls_product_sidebar_link_one_icon' ); ?>"></i>
									<p><strong><?php echo kls_translate_theme_mod( 'kls_product_sidebar_link_one_text', 'Sidebar link text one', 'nl' ); ?></strong><span><a href="<?php echo $option_slug; ?>" target="_blank"><?php echo $option_title; ?></a></span></p>
								</div>
							</li>
							<?php
						endif;

						if ( get_theme_mod( 'kls_product_sidebar_link_two' ) ) :
							$theme_option = get_theme_mod( 'kls_product_sidebar_link_two' );
							$option_slug  = get_permalink( $theme_option );
							$option_title = ( ! empty( get_theme_mod( 'kls_product_sidebar_link_two_text_in_link' ) ) ? kls_translate_theme_mod( 'kls_product_sidebar_link_two_text_in_link', 'Sidebar link text in link two', 'nl' ) : get_the_title( $theme_option ) );
							?>
							<li class="product-sidebar-item">
								<div class="product-sidebar-item-container">
									<i class="<?php echo get_theme_mod( 'kls_product_sidebar_link_two_icon' ); ?>"></i>
									<p><strong><?php echo kls_translate_theme_mod( 'kls_product_sidebar_link_two_text', 'Sidebar link text two', 'nl' ); ?></strong><span><a href="<?php echo $option_slug; ?>" target="_blank"><?php echo $option_title; ?></a></span></p>
								</div>
							</li>
						<?php endif; ?>
					</ul>
				</div>
			</div>
		</div>
		<?php endif; ?>
	</div>

	<div class="theme-container">
		<div class="theme-row">
			<div class="theme-col theme-col-12">
			<?php
				/**
				 * Hook: woocommerce_after_single_product_summary.
				 *
				 * @hooked woocommerce_output_product_data_tabs - 10
				 * @hooked woocommerce_upsell_display - 15
				 * @hooked woocommerce_output_related_products - 20
				 */
				do_action( 'woocommerce_after_single_product_summary' );
			?>
			</div>
		</div>

		<?php if ( get_theme_mod( 'product_recently_viewed_products_toggle' ) == 1 ) { ?>
			<div class="theme-row">
				<div class="theme-col theme-col-12">
					<?php
					do_action( 'recently_viewed_products' );
					?>
				</div>
			</div>
		<?php } ?>
	</div>

	<?php if ( get_theme_mod( 'product_add_divi_shortcode_id' ) != 'none' ) : ?>
		<div class="theme-container">
			<?php echo do_shortcode( '[et_pb_section global_module="' . get_theme_mod( 'product_add_divi_shortcode_id' ) . '"][/et_pb_section]' ); ?>
		</div>
	<?php endif; ?>

</div>
