<?php
/**
 * Order tracking form
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

defined( 'ABSPATH' ) || exit;

global $post;
?>

<div class="theme-container first">
	<?php do_action( 'kls_breadcrumb' ); ?>
	<div class="theme-row">
		<div class="theme-col theme-col-6 theme-col-center">
			<div class="order-tracking-form-wrapper">
				<h3 class="order-tracking-title"><?php echo __( 'Track your order!', 'klasse-theme' ); ?></h3>
				<form action="<?php echo esc_url( get_permalink( $post->ID ) ); ?>" method="post" class="woocommerce-form woocommerce-form-track-order track_order">
					<?php
					/**
					 * Action hook fired at the beginning of the form-tracking form.
					 *
					 * @since 6.5.0
					 */
					do_action( 'woocommerce_order_tracking_form_start' );
					?>

					<p><?php esc_html_e( 'To track your order please enter your Order ID in the box below and press the "Track" button. This was given to you on your receipt and in the confirmation email you should have received.', 'klasse-theme' ); ?></p>

                    <p class="form-row form-row-first"><label for="orderid"><?php esc_html_e( 'Order ID', 'klasse-theme' ); ?></label> <input class="input-text" type="text" name="orderid" id="orderid" value="<?php echo isset( $_REQUEST['orderid'] ) ? esc_attr( wp_unslash( $_REQUEST['orderid'] ) ) : ''; ?>" placeholder="<?php esc_attr_e( 'Found in your order confirmation email.', 'klasse-theme' ); ?>" /></p><?php // @codingStandardsIgnoreLine ?>
                    <p class="form-row form-row-last"><label for="order_email"><?php esc_html_e( 'Billing email', 'klasse-theme' ); ?></label> <input class="input-text" type="text" name="order_email" id="order_email" value="<?php echo isset( $_REQUEST['order_email'] ) ? esc_attr( wp_unslash( $_REQUEST['order_email'] ) ) : ''; ?>" placeholder="<?php esc_attr_e( 'Email you used during checkout.', 'klasse-theme' ); ?>" /></p><?php // @codingStandardsIgnoreLine ?>
					<div class="clear"></div>

					<p class="order-tracking-button-wrapper"><button type="submit" class="theme-button theme-button-primary" name="track" value="<?php esc_attr_e( 'Track', 'klasse-theme' ); ?>"><?php esc_html_e( 'Track', 'klasse-theme' ); ?></button></p>
					<?php
					/**
					 * Action hook fired in the middle of the form-tracking form (before the submit button).
					 *
					 * @since 6.5.0
					 */
					do_action( 'woocommerce_order_tracking_form' );
					?>
					
					<?php wp_nonce_field( 'woocommerce-order_tracking', 'woocommerce-order-tracking-nonce' ); ?>
					<?php
					/**
					 * Action hook fired at the end of the form-tracking form (after the submit button).
					 *
					 * @since 6.5.0
					 */
					do_action( 'woocommerce_order_tracking_form_end' );
					?>

				</form>
			</div>
		</div>
	</div>
</div>
