<?php

/**
 * Order tracking
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 2.2.0
 */

defined( 'ABSPATH' ) || exit;

// $args['notes'] = $args['order']->get_customer_order_notes();
?>
<style>
	body #page-container .woocommerce-customer-details .theme-row {
		width: 100% !important;
	}

 .order_details .product-name a {
	   color: #222222;
		font-weight: normal;
   }

 .woocommerce-order-overview {
	  display: flex;
	 justify-content: space-around;
	 margin-bottom: 30px;
   }

 .order-item {
	  width: 20%;
		text-align: center;
	}

 .order-item strong {
	   display: block;
	}

 .order-details.shop_table{
	 margin-bottom: 0;
  }

 .woocommerce-order-details {
	   padding: 20px;
	 border: 2px solid #eeeeee;
	 margin-bottom: 20px;
   }

 .download-product a{
	   color: #222222;
	}

 @media(hover:hover){
	   .download-product a:hover,
	 .account-orders-table td a:not(.button):hover {
			text-decoration: underline;
		}
  }

 .woocommerce-order-downloads{
	  margin-bottom: 20px;
   }

 .account-orders-table td a {
	   color: #222222;
	}

 .woocommerce-customer-details .theme-row {
	 width: 100% !important;
	}
</style>

<div class="theme-container first">
	<?php do_action( 'kls_breadcrumb' ); ?>

 <div class="theme-row">
		<div class="theme-col theme-col-12">
		   <div class="woocommerce-order-overview woocommerce-thankyou-order-details order_details">
			  <div class="woocommerce-order-overview__order order order-item">
					<?php esc_html_e( 'Order number:', 'klasse-theme' ); ?>
					<strong><?php echo $args['order']->get_order_number(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></strong>
			 </div>

				<div class="woocommerce-order-overview__status status order-item">
					<?php esc_html_e( 'Status', 'klasse-theme' ); ?>
					<strong><?php echo wc_get_order_status_name( $args['order']->get_status() ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></strong>
			  </div>

				<div class="woocommerce-order-overview__date date order-item">
					<?php esc_html_e( 'Date:', 'klasse-theme' ); ?>
					<strong><?php echo wc_format_datetime( $args['order']->get_date_created() ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></strong>
			   </div>

				<div class="woocommerce-order-overview__total total order-item">
					<?php esc_html_e( 'Total:', 'klasse-theme' ); ?>
					<strong><?php echo $args['order']->get_formatted_order_total(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></strong>
			   </div>
		 </div>
	 </div>
 </div>
 <div class="theme-row">
		<div class="theme-col theme-col-12">
			<?php
			if ( $args['notes'] ) :
				?>
			<h2><?php esc_html_e( 'Order updates', 'klasse-theme' ); ?></h2>
		 <ol class="commentlist notes">
				<?php
				foreach ( $args['notes'] as $note ) :
					?>
				<li class="comment note">
				  <div class="comment_container">
						<div class="comment-text">
							<p class="meta"><?php echo date_i18n( esc_html__( 'l jS \o\f F Y, h:ia', 'klasse-theme' ), strtotime( $note->comment_date ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></p>
							<div class="description">
								<?php echo wpautop( wptexturize( $note->comment_content ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
						 </div>
						 <div class="clear"></div>
					  </div>
					 <div class="clear"></div>
				  </div>
			 </li>
					<?php
				endforeach;
				?>
		 </ol>
				<?php
			endif;
			?>

			<?php do_action( 'woocommerce_view_order', $args['order']->get_id() ); ?>
	 </div>
 </div>
</div>
