const defaultConfig = require('@wordpress/scripts/config/webpack.config');
const path = require('path');

const entry = {};
const scripts = [
	'admin/admin',
	'public/actionbar/actionbar',
	'public/faq/faq',
	'public/gravity-forms/toggleable-label',
	'public/navigation/mobile-menu',
	'public/navigation/side-menu',
	'public/owl-carousel/category.slider.owl',
	'public/owl-carousel/product.slider.owl',
	'public/owl-carousel/product.slider.page.owl',
	'public/owl-carousel/product.slider.small.owl',
	'public/woocommerce/product-order-notes-ajax',
	'public/woocommerce/standard_cart',
	'public/woocommerce/standard_checkout',
	'public/woocommerce/standard_checkout_flow',
	'public/woocommerce/standard_general-woocommerce',
	'public/woocommerce/variation-accordion',
	'public/woocommerce/product-submenu',
];

scripts.forEach(
	(script) =>
	(entry[script] = path.resolve(
		process.cwd(),
		`assets/src/${script}.js`
	))
);

const styles = [
	'public/reset',
	'public/standard-theme',
	'public/footer/footer',
	'public/footer/footer_default-v1',
	'public/footer/footer_shop-v2',
	'public/footer/footer_shop-v4',
	'public/form/form',
	'public/popup/popup',
	'public/search/general_search',
	'public/search/menu_search',
	'public/navigation/general_mobile',
	'public/navigation/general_navigation',
	'public/navigation/main/navigation_center-v1',
	'public/navigation/main/navigation_default-v1-fullwidth',
	'public/navigation/main/navigation_default-v1',
	'public/navigation/main/navigation_default-v2-fullwidth',
	'public/navigation/main/navigation_shop-v1-search',
	'public/navigation/main/navigation_shop-v1',
	'public/navigation/main/navigation_shop-v2',
	'public/navigation/main/navigation_shop-v3',
	'public/navigation/main/navigation_shop-v4',
	'public/navigation/main/navigation_shop-v5',
	'public/navigation/mobile/mobile_anytime-v1',
	'public/navigation/mobile/mobile_bottom_bar_shop-v2',
	'public/navigation/mobile/mobile_bottom_bar-v1',
	'public/navigation/mobile/mobile_default-v1',
	'public/navigation/sidebar/sidebar_shop-v5',
	'public/navigation/sidemenu/sidemenu_v1',
	'public/navigation/top/top_default-v1',
	'public/navigation/top/top_shop-v1',
	'public/woocommerce/standard_archive',
	// 'public/woocommerce/standard_cart',
	// 'public/woocommerce/standard_checkout_flow',
	// 'public/woocommerce/standard_checkout',
	// 'public/woocommerce/standard_general_woocommerce',
	'public/woocommerce/standard_giftcard',
	'public/woocommerce/standard_menu-my-account',
	'public/woocommerce/standard_menu-wishlist',
	'public/woocommerce/standard_mini-cart',
	'public/woocommerce/standard_my-account',
	'public/woocommerce/standard_product-slider-page',
	'public/woocommerce/standard_product-slider',
	'public/woocommerce/standard_product',
	'public/woocommerce/standard_quickview',
	'public/woocommerce/standard_wishlist',
	// 'public/woocommerce/variation-accordion',

	'public/woocommerce/v1/archive',
	'public/woocommerce/v1/cart',
	'public/woocommerce/v1/checkout_flow',
	'public/woocommerce/v1/checkout',
	'public/woocommerce/v1/general_woocommerce',
	'public/woocommerce/v1/giftcard',
	'public/woocommerce/v1/menu-my-account',
	'public/woocommerce/v1/menu-wishlist',
	'public/woocommerce/v1/mini-cart',
	'public/woocommerce/v1/my-account',
	'public/woocommerce/v1/product',
	'public/woocommerce/v1/quickview',
	'public/woocommerce/v1/wishlist',
	
	'public/woocommerce/v2/archive',
	'public/woocommerce/v2/cart',
	'public/woocommerce/v2/checkout_flow',
	'public/woocommerce/v2/checkout',
	'public/woocommerce/v2/general_woocommerce',
	'public/woocommerce/v2/giftcard',
	'public/woocommerce/v2/menu-my-account',
	'public/woocommerce/v2/menu-wishlist',
	'public/woocommerce/v2/mini-cart',
	'public/woocommerce/v2/my-account',
	'public/woocommerce/v2/product',
	'public/woocommerce/v2/quickview',
	'public/woocommerce/v2/wishlist',

	'public/woocommerce/v3/archive',
	'public/woocommerce/v3/cart',
	'public/woocommerce/v3/checkout_flow',
	'public/woocommerce/v3/checkout',
	'public/woocommerce/v3/general_woocommerce',
	'public/woocommerce/v3/giftcard',
	'public/woocommerce/v3/menu-my-account',
	'public/woocommerce/v3/menu-wishlist',
	'public/woocommerce/v3/my-account',
	'public/woocommerce/v3/product',
	'public/woocommerce/v3/quickview',
	'public/woocommerce/v3/wishlist',

	'public/woocommerce/v4/cart',
	'public/woocommerce/v4/checkout_flow',
	'public/woocommerce/v4/checkout',
	'public/woocommerce/v4/general_woocommerce',
	'public/woocommerce/v4/giftcard',
	'public/woocommerce/v4/menu-my-account',
	'public/woocommerce/v4/menu-wishlist',
	'public/woocommerce/v4/my-account',
	'public/woocommerce/v4/product',
	'public/woocommerce/v4/quickview',
	'public/woocommerce/v4/wishlist',

	'public/woocommerce/v5/general_woocommerce',
	'public/woocommerce/v5/giftcard',
	'public/woocommerce/v5/menu-my-account',
	'public/woocommerce/v5/menu-wishlist',
	'public/woocommerce/v5/my-account',
	'public/woocommerce/v5/product',
	'public/woocommerce/v5/quickview',
	'public/woocommerce/v5/wishlist',

	'public/woocommerce/v6/general_woocommerce',
	'public/woocommerce/v6/giftcard',
	'public/woocommerce/v6/menu-my-account',
	'public/woocommerce/v6/menu-wishlist',
	'public/woocommerce/v6/my-account',
	'public/woocommerce/v6/product',
	'public/woocommerce/v6/quickview',
	'public/woocommerce/v6/wishlist',

	'public/woocommerce/v7/product',
];

styles.forEach(
	(style) => 
	(entry[style] = path.resolve(
		process.cwd(), 
		`assets/src/${style}.scss`
	))
);

module.exports = {
	...defaultConfig,
	entry,
	output: {
		path: path.join(__dirname, './assets/build'),
	},
	externals: {
		react: 'React',
		'react-dom': 'ReactDOM',
	},
};
