<?php
/**
 * Checkout login form
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.8.0
 */

defined( 'ABSPATH' ) || exit;

if ( is_user_logged_in() || 'no' === get_option( 'woocommerce_enable_checkout_login_reminder' ) ) {
	return;
}

?>
<div class="theme-row">
	<div class="theme-col theme-col-7 woocommerce-checkout-login">
		<div class="woocommerce-form-login-toggle">
			<?php echo esc_html__( 'Returning customer?', 'klasse-theme' ) . ' <a href="#" class="showlogin button-link">' . esc_html__( 'Click here to login', 'klasse-theme' ) . '</a>'; ?>
		</div>
		<?php

		if ( ! empty( get_theme_mod( 'checkout_login_message_text' ) ) ) {
			$heading = kls_translate_theme_mod( 'checkout_login_message_text', 'Checkout login text', 'nl' );
		} else {
			$heading = esc_html__( 'If you have shopped with us before, please enter your details below. If you are a new customer, please proceed to the Billing section.', 'klasse-theme' );
		}

		woocommerce_login_form(
			array(
				'message'  => esc_html__( 'If you have shopped with us before, please enter your details below. If you are a new customer, please proceed to the Billing section.', 'klasse-theme' ),
				'redirect' => wc_get_checkout_url(),
				'hidden'   => true,
			)
		);
		?>
	</div>
</div>
