<?php
/**
 * Gift Cards
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce Gift Cards
 * @version 1.1.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


echo "=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=\n";
echo esc_html( wp_strip_all_tags( $email_heading ) );
echo "\n=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=\n\n";

/* translators: %s: Sender name */
echo esc_html( wp_strip_all_tags( wptexturize( apply_filters( 'woocommerce_email_intro_content', $intro_content, $giftcard ) ) ) );
/* translators: %s: Gifcard amount */
echo sprintf( esc_html_x( 'Amount %s', 'Email gift card received', 'klasse-theme' ), wc_price( $giftcard->get_balance() ) ) . "\n\n";
/* translators: %s: Gifcard code */
echo sprintf( esc_html_x( 'Code: %s', 'Email gift card received', 'klasse-theme' ), esc_html( $giftcard->get_code() ) );

if ( $giftcard->get_expire_date() > 0 ) {
	/* translators: %s: Gift card expiration date */
	echo "\n\n" . sprintf( esc_html_x( 'Expires on %s', 'Email gift card received', 'klasse-theme' ), esc_html( date_i18n( get_option( 'date_format' ), $giftcard->get_expire_date() ) ) );
}

echo "\n\n----------------------------------------\n\n";

/**
 * Show user-defined additional content - this is set in each email's settings.
 */
if ( $additional_content ) {
	echo esc_html( wp_strip_all_tags( wptexturize( $additional_content ) ) );
	echo "\n\n----------------------------------------\n\n";
}

echo wp_kses_post( apply_filters( 'woocommerce_email_footer_text', get_option( 'woocommerce_email_footer_text' ) ) );
