<?php

/**
 * Displayed when no products are found matching the current query
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 2.0.0
 */

defined( 'ABSPATH' ) || exit;

?>
<div class="archive-no-products-found">
	<p><?php esc_html_e( 'No products were found matching your selection.', 'klasse-theme' ); ?></p>
	<?php
	if ( ! is_shop() || is_search() ) :
		?>
	<a href="<?php echo get_permalink( wc_get_page_id( 'shop' ) ); ?>" class="theme-button theme-button-primary"><?php echo __( 'Go to the shop', 'klasse-theme' ); ?></a>
		<?php
	endif;
	?>
</div>
