<?php

/**
 * Show options for ordering
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     3.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( get_theme_mod( 'kls_archive_show_sorting', 1 ) == 1 ) :
	?>
<form class="woocommerce-ordering" method="get">
	<label for="orderby"><?php echo __( 'Sort by:', 'klasse-theme' ); ?> </label>
	<select name="orderby" class="orderby" id="orderby" aria-label="<?php esc_attr_e( 'Shop order', 'klasse-theme' ); ?>">
		<?php
		foreach ( $catalog_orderby_options as $id => $name ) :
			?>
			<option value="<?php echo esc_attr( $id ); ?>" <?php selected( $orderby, $id ); ?>><?php echo esc_html( $name ); ?></option>
			<?php
		endforeach;
		?>
 </select>
  <input type="hidden" name="paged" value="1" />
	<?php wc_query_string_form_fields( null, array( 'orderby', 'submit', 'paged', 'product-page' ) ); ?>
</form>
	<?php
endif;
