<?php

/**
 * Lost password reset form.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

defined( 'ABSPATH' ) || exit;?>

<div class="theme-container">
	<?php
	do_action( 'kls_breadcrumb' );

	do_action( 'woocommerce_before_reset_password_form' );
	?>

	<div class="theme-row">
		<div class="theme-col theme-col-12">
            <h3 class="account-page-title"><?php echo apply_filters( 'woocommerce_reset_password_message', esc_html__( 'Enter a new password below.', 'klasse-theme' ) ); ?></h3><?php // @codingStandardsIgnoreLine ?>
			<form method="post" class="woocommerce-ResetPassword lost_reset_password">
				<p class="woocommerce-form-row woocommerce-form-row--first form-row form-row-first">
					<label for="password_1"><?php esc_html_e( 'New password', 'klasse-theme' ); ?>&nbsp;<span class="required">*</span></label>
					<input type="password" class="woocommerce-Input woocommerce-Input--text input-text" name="password_1" id="password_1" autocomplete="new-password" />
				</p>
				<p class="woocommerce-form-row woocommerce-form-row--last form-row form-row-last">
					<label for="password_2"><?php esc_html_e( 'Re-enter new password', 'klasse-theme' ); ?>&nbsp;<span class="required">*</span></label>
					<input type="password" class="woocommerce-Input woocommerce-Input--text input-text" name="password_2" id="password_2" autocomplete="new-password" />
				</p>

				<input type="hidden" name="reset_key" value="<?php echo esc_attr( $args['key'] ); ?>" />
				<input type="hidden" name="reset_login" value="<?php echo esc_attr( $args['login'] ); ?>" />

				<div class="clear"></div>

				<?php do_action( 'woocommerce_resetpassword_form' ); ?>

				<p class="">
					<input type="hidden" name="wc_reset_password" value="true" />
					<button type="submit" class="theme-button theme-button-primary button" value="<?php esc_attr_e( 'Save', 'klasse-theme' ); ?>"><?php esc_html_e( 'Save', 'klasse-theme' ); ?></button>
				</p>

				<?php wp_nonce_field( 'reset_password', 'woocommerce-reset-password-nonce' ); ?>

			</form>
		</div>
	</div>
</div>
<?php
do_action( 'woocommerce_after_reset_password_form' );
